const Backbone = require("backbone");
const Handlebars = require("handlebars");
const Marionette = require("backbone.marionette");

const btns = [
	{
		"btnId": "saveCaseTab0",
		"btnXtraCase": "save-case",
		"btnName": "saveCaseNameTab0",
		"btnTitle": "Save this Case",
		"btnLabel": "Save Case"
	},
	{
		"btnId": "closeCaseTab0",
		"btnXtraCase": "",
		"btnName": "closeCaseNameTab0",
		"btnTitle": "Close this Case",
		"btnLabel": "Close Case"
	},
	{
		"btnId": "cancelCaseTab0",
		"btnXtraCase": "",
		"btnName": "cancelCaseNameTab0",
		"btnTitle": "Cancel this Case",
		"btnLabel": "Cancel Case"
	},
	{
		"btnId": "clearCaseTab0",
		"btnXtraCase": "",
		"btnName": "clearCaseNameTab0",
		"btnTitle": "Clear all data",
		"btnLabel": "Clear Case"
	},
	{
		"btnId": "cancelTab0",
		"btnXtraCase": "",
		"btnName": "cancelNameTab0",
		"btnTitle": "Cancel this screen",
		"btnLabel": "Exit Without Saving"
	}
];

module.exports = Marionette.View.extend({
	template: require("./case_tab_buttons.hbs"),
	events: {
		"click button": "buttonClick"
	},
	buttonClick(evt) {
		const lut = {
			"saveCaseNameTab0": "save",
			"closeCaseNameTab0": "close",
			"cancelCaseNameTab0": "cancel",
			"clearCaseNameTab0": "clear",
			"cancelNameTab0": "exit"
		};
		this.trigger("action", lut[evt.target.name]);
	},
	templateContext() {
		return {"Buttons": btns};
	},
	onRender() {
		if(this.options.closeOrCancel !== "close") {
			this.$("#closeCaseTab0").remove();
		}

		if(this.options.closeOrCancel !== "cancel") {
			this.$("#cancelCaseTab0").remove();
		}

		if(this.options.closeOrCancel !== "clear") {
			this.$("#clearCaseTab0").remove();
		}
	}
});
