const _ = require("underscore");
const Backbone = require("backbone");
const Handlebars = require("handlebars");
const Marionette = require("backbone.marionette");
const SelectView = require("../../../utils/select/view");

module.exports = Marionette.View.extend({
	className: "case-tab-panel",
	template: require("./case_summary.hbs"),
	templateContext() {
		let patientName = undefined;
		let patient = this.model.getPatient();
		if (patient) patientName = patient.get("name");
		const ctx = {
			patientName: patientName
		};
		return ctx;
	},
	onRender() {
		this.$("input:text").attr({autocomplete: "off", maxlength: 255});

		if (!this.model) {
			return;
		}
	}
});
