const Backbone = require("backbone");
const Marionette = require("backbone.marionette");
const Radio = require("backbone.radio");
const authHeaders = require("../../../utils/authHeaders");
const IndexView = require("../../../modules/index/view");
const ClosureReasonsCollection 	= require("../../../entities/case/closure_reasons/collection");
const TooltipBehavior = require("../../../behaviors/tooltip");

module.exports = Marionette.StateView.extend({
	template: require("./template.hbs"),

	ui: {
		ok: "#ok",
		cancel: "#cancel",
		close: "#close",
		question: "#question"
	},

	defaultState: {
		reasons: [
			{
				"id": "3",
				"name": "CASE NO LONGER MEETS CRITERIA"
			},
			{
				"id": "4",
				"name": "CASE WAS NOT VERIFIED"
			},
			{
				"id": "6",
				"name": "CONVERTED"
			},
			{
				"id": "7",
				"name": "NOT CONVERTED"
			},
			{
				"id": "5",
				"name": "OLD CASE NO ACTION"
			},
			{
				"id": "1",
				"name": "RECEIVED VERIFIED MEANS TEST"
			},
			{
				"id": "2",
				"name": "REJECTED VETERAN SSN"
			}
		]
	},

	stateEvents: {
		"change": "render"
	},

	triggers: {
		"click @ui.ok": "ok",
		"click @ui.cancel": "cancel",
		"click @ui.close": "close",
		"click @ui.question": "question"
	},

	behaviors: { TooltipBehavior },

	templateContext() {

		const closureReasons = this.getOption("closureReasons");

		console.log("Rendering from case_list view:\n", {
			closureReasons: closureReasons ? closureReasons.toJSON() : undefined
		});

		return {
			closureReasons: closureReasons ? closureReasons.toJSON() : undefined
		};
	},

	onOk() {
		Radio.request("root", "close:modal");
		Backbone.history.navigate( "/", { trigger: false, replace: true } );
		Radio.request("root", "body", new IndexView({}));
	},

	onCancel() {
		Radio.request("root", "close:modal");
	},

	onClose() {
		Radio.request("root", "close:modal");
	},

	onQuestion() {
		Radio.request("root", "close:modal");
		let href = "https://ehmp.vistacore.us/help/eHMP_Page%20Not%20Found.htm";
		let left = (screen.width/2)-(900/2);
		let top = (screen.height/2)-(600/2);
		window.open(href, "Widget Help", `top=${top}, left=${left}, width=800, height=450`);
	},

	/**
	 * Order of execution:
	 * 1: initialize
	 * 2: onRender
	 * 3: onAttach
	 * 4: onDomRefresh
	 */
	initialize: function() {

		// Needed when using StateView - calls its constructor
		Marionette.StateView.prototype.initialize.apply(this, arguments);

		// Collect relevant data from Radio channel
		Object.assign(this.options, {
			closureReasons: new ClosureReasonsCollection()
		});
	},

	onAttach() {
		this.loadClosureReasons();
		console.log("Attaching Cancel view");
	},

	/**
	 * Method for calling closure reasons for closing cases
	 */
	loadClosureReasons() {
		this.closureReasons = new ClosureReasonsCollection();
		return this.closureReasons.fetch(authHeaders())
			.then(() => {console.log(this.getOption("closureReasons"));});
	}
});
