const Marionette = require("backbone.marionette");
const CalendarView = require("./calendar/view");
const FilterView = require("./filter/view");

module.exports = Marionette.View.extend({
	className: "flexIt flexIt-container",
	template: require("./template.hbs"),

	regions: {
		filters: {
			el: ".js-region-filters",
			replaceElement: true
		},
		calendar: {
			el: ".js-region-calendar",
			replaceElement: true
		}
	},

	onAttach() {
		this.showChildView("filters", new FilterView({parent: this}));

		// A null argument will allow the graphical calendar to show up empty. Previously, when
		// this.collection was being passed as an argument, it was generating a JavaScript "hasTimes"
		// error because in looping through all cases, some of them had undefined start or end times.
		this.loadGraphicalCalendar(null, null);
	},

	/**
	 * Method that loads the graphical calendar. This method is needed as it is called from more than
	 * one place in the code (i.e., the filter form).
	 */
	loadGraphicalCalendar(caseCollection, workTimes, allWorkTimes) {
		this.showChildView("calendar", new CalendarView({
			collection: caseCollection,
			workTimes: workTimes,
			allWorkTimes: allWorkTimes
		}));
	}
});
