const $ = require("jquery");
const Sciatic = require("backbone.sciatic");
const Radio = require("backbone.radio");
const CalendarView = require("./view");
const Events = require("./events.json");
const CaseCollection = require("../../entities/case/collection");
const authHeaders = require("../../utils/authHeaders");

module.exports = Sciatic.Route.extend({
	fetch(routeData) {
		const cases = new CaseCollection();
		return cases.fetch(authHeaders())
			.then(() => Object.assign(routeData, { cases }));
	},

	show(routeData) {
		Radio.request("root", "body", new CalendarView({ collection: routeData.cases }));
	}
});
