const Marionette = require("backbone.marionette");

module.exports = Marionette.View.extend({
	id: "calendar",
	className: "flexIt-grow flexIt-scroll",
	template: false,
	onAttach() {

		let calendarData = null;
		let businessHoursData = null;
		let allProviderWorkHoursData = null;
		let defaultDate = new Date();

		// When calendar is first loaded, this.collection will come in as null
		if(this.collection !== undefined && this.collection !== null && this.collection.models.length > 0) {

			if(this.validateCollection()) {

				//defaultDate = this.collection.models[0].get("scheduledStartTime");

				calendarData = this.collection.models.map(aCase => ({
					title: "CPT: " + aCase.get("principalProcedure") + "\nCase ID: " + aCase.get("ien"),
					start: aCase.get("scheduledStartTime"),
					end: aCase.get("scheduledEndTime"),
					backgroundColor: "#337ab7"
				}));

			} else {
				// Show error message saying start or end times are incorrect
				alert("There was an error with on of the cases start or end times");
			}
		}

		// Now add the work hours: this.workTimes
		if(this.options.workTimes !== undefined && this.options.workTimes !== null) {

			businessHoursData = [];
			$(this.options.workTimes.attributes.results).each((key, wtElem) => {

				let dow = (wtElem.dow !== undefined && wtElem.dow !== null) ? wtElem.dow : null;
				businessHoursData.push({
					start: wtElem.start,
					end: wtElem.end,
					dow: dow,
					rendering: "background"
				});
			});
		}

		if(this.options.allWorkTimes !== undefined && this.options.allWorkTimes !== null) {
			allProviderWorkHoursData = this.options.allWorkTimes.attributes.results;
			console.log(allProviderWorkHoursData);
		}

		// Show calendar if calendarData is null since it will show an empty calendar.
		this.$el.fullCalendar({
			header: {
				left: "prev,next today",
				center: "title",
				right: "month,agendaWeek,agendaDay,listWeek"
			},
			defaultView: "agendaWeek",
			defaultDate: defaultDate,
			allDaySlot: false,
			editable: true,
			events: calendarData,
			businessHours: businessHoursData,

			// Bootstrap tooltip
			eventRender: function(event, element) {
				$(element).tooltip({
					html: true,
					title: event.title.replace(/\n/g,"<br/>")
				});
			},

			viewRender: function(view,element) {

				if (view.name === "agendaWeek") {

					// The two lines of code below is a solution to the agendaWeek view not displaying vertical
					// column lines. It works in conjunction with some CSS styles in the calendar CSS file. The
					// styles it works with are: .fc .fc-agendaWeek-view .fc-bg tr > td:not(.fc-today),
					// .td.fc-today, .fc th, .fc-agenda-view .fc-day-grid

					// Take away background to enable vertical grid lines to show.
					// CSS will fill in background color of cells individually.
					$("#calendar table").css("background-color", "transparent");

					// Fill in one of two top right corner cells with white background
					$(".fc-head").children("tr:first").children("td:first").css("background-color", "white");

					// Display tooltip that shows a list of providers working on any given day of the week
					// on the header of each day of the week.
					let index = 0;
					//let tooltipContainer = "<p style=\"font-family:Tahoma;font-color:#f5deb3;font-size:10px\"/>Providers ";
					let tooltipContainer = "<p><font face=\"Verdana\" size=\"1px\" color=\"yellow\">PROVIDERS - ";
					$("div.fc-row.fc-widget-header table thead tr th").each((key, thElem) => {
						if( thElem.className !== "fc-axis fc-widget-header") {

							let providerList = "";
							if(allProviderWorkHoursData !== undefined && allProviderWorkHoursData !== null) {

								let schedule = allProviderWorkHoursData[index].schedule;
								if(schedule !== undefined && schedule !== null && schedule.length > 0) {

									//providerList += "<p style=\"margin-top:20px;font-family:Tahoma;font-color:#fff;font-size:10px\"/>";
									providerList += "</font><p><font face=\"Verdana\" size=\"1px\" color=\"white\">";
									$(schedule).each((key, schedElem) => {

										providerList += schedElem.name;
										if(schedElem.workHours !== undefined && schedElem.workHours !== null && schedElem.workHours.length > 0) {
											$(schedElem.workHours).each((key, whElem) => {
												providerList += ": " + whElem.start + " - " + whElem.end + "<br/>";
											});
										} else {
											providerList += "n/a";
										}
									});
								}
							}

							$(thElem).children("span").tooltip({
								title: tooltipContainer + thElem.attributes[1].value + providerList + "</font>",
								html: "true",
								placement: "bottom"
							});

							index++;
						}
					});
				}
			}
		});
	},

	validateCollection() {

		let isValidated = true;

		$.each(this.collection.models, (key, aCase) => {

			let aScheduledStartTime = aCase.get("scheduledStartTime");
			let aScheduledEndTime = aCase.get("scheduledEndTime");

			if(aScheduledStartTime === undefined || aScheduledStartTime === null || aScheduledStartTime === "" ||
				aScheduledEndTime === undefined || aScheduledEndTime === null || aScheduledEndTime === "") {
				isValidated = false;
				return false;
			}
		});

		return isValidated;
	}
});
