const Marionette 		= require("backbone.marionette");
const Radio      		= require("backbone.radio");
const storage    		= require("../../utils/storage");
const aheader    		= require("../../utils/authHeaders");
const RolesCollection 	= require("../../entities/administration/roles/collection");
const RolesModel 	= require("../../entities/administration/roles/model");
const KeysModel 		= require("../../entities/administration/keys/model");


module.exports = Marionette.StateView.extend({
	template: require("./template.hbs"),

	onAttach() {
		this.loadRoles();
	},

	defaultState: {
		"loading": true,
	},

	stateEvents: {
		"change": "render"
	},

	ui: {
		role: 'select[name="role"]',
	},

	events: {
		// "submit form": "submit"
		"change @ui.role": "onSelectRole"
	},

	triggers: {
		"click #updateRoles": "click:updateRoles",
		"click #createRoles": "click:createRoles",
		"click #deleteRoles": "click:deleteRoles"
	},

	onClickUpdateRoles(){
		const roleId = this.ui.role.val();
		var roles =  new RolesModel({_id: roleId});

		console.log("Printing POST URL::"+roles.url());

		roles.toJSON();

		roles.save(aheader(), this.getOption('selectedRole').toJSON(), {
			wait:true,
			success:function(model, response) {
				console.log('Successfully updated Role!');
			},
			error: function(model, error) {
				console.log(model.toJSON());
				console.log('error.responseText');
			}
		});
	},

	onClickCreateRoles(){
		console.log("inside create Roles");
	},

	onClickDeleteRoles(){
		console.log("inside delete Roles");
	},

	templateContext() {
		const roles = this.getOption("roles");
		const totalkeys = this.getOption("totalkeys");
		const selectedRole = this.getOption('selectedRole');

		return {
			roles: roles ? roles.toJSON() : undefined,
			totalkeys: totalkeys ? totalkeys.toJSON() : undefined,
			selectedRole: selectedRole ? selectedRole.toJSON() : undefined,
		};

	},

	loadRoles() {
		this.totalkeys = new KeysModel();
		this.roles = new RolesCollection();

		this.state.set("loading", true);

		return Promise.all([
			this.totalkeys.fetch(aheader()),
			this.roles.fetch(aheader())
		])
			.then(() => this.state.set("loading", false));
	},

	onSelectRole() {
		const roleId = this.ui.role.val();
		const selectedRole = this.roles.get(roleId);

		this.selectedRole = selectedRole;
		this.render();
	}
});
