const Marionette = require("backbone.marionette");
const Radio = require("backbone.radio");
const storage = require("../../../utils/storage");
const authHeaders = require("../../../utils/authHeaders");
const RolesCollection = require("../../../entities/administration/user_role_config/roles/collection");
const RolesModel = require("../../../entities/administration/user_role_config/roles/model");
const KeysModel = require("../../../entities/administration/user_role_config/keys/model");

module.exports = Marionette.StateView.extend({
	className: "flexIt flexIt-container",
	template: require("./template.hbs"),

	onAttach() {
		this.loadRoles();
	},

	defaultState: {
		"loading": true
	},

	stateEvents: {
		"change": "render"
	},

	ui: {
		"role": "select[name=\"role\"]"
	},

	events: {
		"change @ui.role": "onSelectRole",
		"change #keysCheckboxes": "clicked"
	},

	triggers: {
		"click #updateRoles": "click:updateRoles"
	},

	clicked(){

		// TODO: Change this JQuery to Handlebars
		if ($("#updateRoles").prop("disabled")) {
			$("#updateRoles").prop("disabled", false);
		}
	},

	onClickUpdateRoles(){
		const roleId = this.ui.role.val();
		const listCheck = [];

		$("input[type=checkbox]:checked").each(function() {
			listCheck.push($(this).val());
		});

		this.selectedRole.set({"keys": listCheck});
		this.selectedRole.save(null, authHeaders())
			.then(() => this.render());
	},

	templateContext() {
		const roles = this.getOption("roles");
		const totalkeys = this.getOption("totalkeys");
		const selectedRole = this.getOption("selectedRole");

		return {
			roles: roles ? roles.toJSON() : undefined,
			totalkeys: totalkeys ? totalkeys.toJSON() : undefined,
			selectedRole: selectedRole ? selectedRole.toJSON() : undefined
		};
	},

	loadRoles() {
		this.totalkeys = new KeysModel();
		this.roles = new RolesCollection();
		this.state.set("loading", true);

		return Promise.all([
			this.totalkeys.fetch(authHeaders()),
			this.roles.fetch(authHeaders())
		])
			.then(() => {
				console.log("The Loading State - ", this.state.get("loading"));
				this.state.set("loading", false);
			});
	},

	onSelectRole() {
		const roleId = this.ui.role.val();
		const selectedRole = this.roles.get(roleId);
		this.selectedRole = selectedRole;
		this.render();
	}
});
