const Marionette = require("backbone.marionette");
const Radio = require("backbone.radio");
const authHeaders = require("../../../utils/authHeaders");
const SSLQIModel = require("../../../entities/administration/sslqi_management/model");
const SSLQICollection = require("../../../entities/administration/sslqi_management/collection");
const SSLQITabContentPanel = require("../../case/components/sslqi_tab_content_panel");

module.exports = Marionette.StateView.extend({
	className: "flexIt flexIt-container",
	template: require("./template.hbs"),

	regions: {
		tabPanelRegion: "#tabPanel"
	},

	ui: {
		formxxx: "#sslqiForm"
	},

	defaultState: {
		showTabsPanel: true
	},

	stateEvents: {
		"change": "render"
	},

	events: {

	},

	templateContext() {
		const currentSSLQI = this.getOption("currentSSLQI");
		const ctx = {
			currentSSLQI: currentSSLQI ? currentSSLQI.toJSON() : undefined
		};
		console.log("Rendering from sslqi_management view:\n", ctx);
		return ctx;
	},

	initialize: function() {

		// Needed when using StateView - calls its constructor
		Marionette.StateView.prototype.initialize.apply(this, arguments);

		Object.assign(this.options, {
			currentSSLQI: new SSLQIModel()
		});
	},

	onAttach: function() {
		this.ui.formxxx.show();
	},

	onRender: function () {
		if (this.state.get("showTabsPanel")) {
			this.showChildView("tabPanelRegion", new SSLQITabContentPanel({
				currentSSLQI: this.options.currentSSLQI,
				parent: this,
				isNewSSLQI: true
			}));
		}
	},

	onDomRefresh: function() {
	}

});
