const { Route } = require("backbone.sciatic");
const _ = require("underscore");
const Radio = require("backbone.radio");
const SSLQISearchView = require("./view");
const { auth } = require("../../../../utils/mixins");
const authHeaders = require("../../../../utils/authHeaders");

module.exports = Route.extend({
	filters: [auth],

	show(routeData) {
		Radio.request("root", "body", new SSLQISearchView({
			filters: _.pick(routeData.query, "category", "type", "specialty"),
		}));
	}
});
