const { Route } = require("backbone.sciatic");
const Radio = require("backbone.radio");
const { auth } = require("../../../../utils/mixins");
const authHeaders = require("../../../../utils/authHeaders");
const SSLQIModel = require("../../../../entities/administration/sslqi_management/model");
const EditSSLQIView = require("./view");

module.exports = Route.extend({
	filters: [auth],

	fetch(routeData) {
		const { id } = routeData.params;

		routeData.sslqi = new SSLQIModel();
		if (id === "new") { return Promise.resolve(); }

		return routeData.sslqi
			.set("_id", id)
			.fetch(authHeaders());
	},

	show({ sslqi }) {
		Radio.request("root", "body", new EditSSLQIView({ model: sslqi }));
	}
});
