const Marionette = require("backbone.marionette");
const authHeaders = require("../../../utils/authHeaders");
const SpecialtyCollection = require("../../../entities/administration/specialty/collection");
const RoomsCollection = require("../../../entities/administration/room_config/collection");
const DfltRoomsCollection = require("../../../entities/administration/room_specialty_config/collection");
const DfltRoomsModel = require("../../../entities/administration/room_specialty_config/model");
const SpecialtyListView = require("./specialties/list/view");

module.exports = Marionette.StateView.extend({
	className: "flexIt flexIt-container",
	template: require("./template.hbs"),

	defaultState: {
		"loading": true
	},

	stateEvents: {
		"change": "render"
	},

	regions: {
		"specialty-list": {
			el: ".r-specialty-list",
			replaceElement: true
		}
	},

	onRender() {
		if (!this.state.get("loading") && this.Specialty) {
			let i=0;
			let theCollectionArray = this.Specialty.models;
			for (let aSpecialty of theCollectionArray) {
				if (i++ %2) {
					aSpecialty.attributes.odd=true;
				}
			}
			this.showChildView("specialty-list", new SpecialtyListView({
				collection: this.Specialty,
				rooms: this.Rooms
			}));
		}
	},

	onChildviewChildviewUpdateRoomConfig(data) {
		let aModel = new DfltRoomsModel( {
			"specialty": data.attributes.id,
			"orNonOr": data.attributes.orNonOr,
			"defaultRoom": data.attributes.room
		});
		const whichRecord = this.dfltRooms.findWhere({"specialty": data.attributes.id});
		if (whichRecord) {
			aModel.attributes._id = data.attributes.id;
		}
		aModel.save(null, authHeaders());
	},

	onAttach() {
		this.loadData();
	},

	loadData() {
		this.Rooms = new RoomsCollection();
		this.Specialty = new SpecialtyCollection();
		this.dfltRooms = new DfltRoomsCollection();
		this.state.set("loading", true);

		return Promise.all([
			this.Specialty.fetch(authHeaders()),
			this.Rooms.fetch(authHeaders()),
			this.dfltRooms.fetch(authHeaders())
		])

			// Here we're going to massage-in some default room
			// data that we've fetched to the Specialty collection
			.then(() => {
				this.dfltRooms.each((room) => {
					const specialty = this.Specialty.get(room.get("specialty"));
					if (!specialty) { return; }

					// If there's a matching specialty, mix-in the data
					// from the default config provided.
					specialty.set({
						room: room.get("defaultRoom"),
						orNonOr: room.get("orNonOr")
					});
				});
			})
			.then(() => this.state.set("loading", false));
	}
});
