const Marionette = require("backbone.marionette");
require("bootstrap-select");
const SelectView = require("../../../../../utils/select/view");
const authHeaders = require("../../../../../utils/authHeaders");

module.exports = Marionette.StateView.extend({
	tagName: "tr",
	template: require("./template.hbs"),

	regions: {
		"room-select": ".r-room-select"
	},

	ui: {
		orRadio: ".or-radio"
	},

	triggers: {
		"change @ui.orRadio": "change:type"
	},

	onRender() {
		if (this.model.attributes.odd) {
			this.el.className = "Odd";
		}
		let aRoom, theRooms2Select = this.getOption("rooms").models;
		for (aRoom of theRooms2Select) {
			aRoom.attributes.dspData = `${aRoom.attributes.name} - ${aRoom.attributes.location} (${aRoom.attributes.contact})`;
			aRoom.attributes.id = aRoom.attributes.ien;
		}
		const selectView = new SelectView({
			"collection": this.getOption("rooms"),
			"ariaLabel": "specialtylabel roomlabel"
		});

		let theRoom = this.model.get("room");
		if (theRoom) {
			selectView.state.set("selected", theRoom.toString());
		}
		this.showChildView("room-select", selectView);
		$(".selectpicker").selectpicker("refresh");
	},

	onChangeType() {
		this.model.set("orNonOr", this.ui.orRadio.filter(":checked").val());
		this.triggerMethod("update:roomConfig", this.model);
	},

	// When a new room is selected, update the specialty model
	onChildviewChangeValue() {
		const selectedRoom = this.getChildView("room-select").state.get("selected");
		this.model.set("room", selectedRoom);
		this.triggerMethod("update:roomConfig", this.model);
	}
});
