const { StateView } = require("backbone.marionette");
const Radio = require("backbone.radio");
const SelectPicker = require("../../../behaviors/select-picker");
const ListsSelect = require("../../../utils/entity-select/lists");
const CPTSelect = require("../../../utils/entity-select/cpt_procedure");
const authHeaders = require("../../../utils/authHeaders");

module.exports = StateView.extend({
	className: "flexIt flexIt-container flexIt-grow caseDuration",
	template: require("./template.hbs"),

	defaultState: {
		loading: false,
		hasQuery: false,
		showFilters: true,
		cptFilter: null,
		providerFilter: null,
		specialtyFilter: null
		// siteFilter: null
	},

	stateEvents: {
		change: "render"
	},

	regions: {
		cpt: ".js-r-cptFilter",
		specialty: ".js-r-specialtyFilter",
		provider: ".js-r-providerFilter",
		results: { el: ".js-r-results", replaceElement: true }
	},

	ui: {
		trigger: ".js-filterTrigger",
		form: ".js-filterForm",
		clear: ".js-clear",
		cancel: ".js-cancel"
	},

	triggers: {
		"click @ui.trigger": "toggle:filters",
		"click @ui.clear": "clear",
		"click @ui.cancel": "cancel",
		"submit @ui.form": "submit:form"
	},

	behaviors: { SelectPicker },

	onRender() {
		if (this.state.get("showFilters")) {
			const cptView = new CPTSelect({ selected: this.state.get("cptFilter") });
			this.listenTo(cptView, "change", this.updateCPT, this);
			this.showChildView("cpt", cptView);

			const providerView = new ListsSelect.People({ selected: this.state.get("providerFilter") });
			this.listenTo(providerView, "change", this.updateProvider, this);
			this.showChildView("provider", providerView);

			const specialtyView = new ListsSelect.Specialty({ selected: this.state.get("specialtyFilter") });
			this.listenTo(specialtyView, "change", this.updateSpecialty, this);
			this.showChildView("specialty", specialtyView);
		}


	},

	updateCPT(value) { this.state.set("cptFilter", value); },
	updateProvider(value) { this.state.set("providerFilter", value); },
	updateSpecialty(value) { this.state.set("specialtyFilter", value); },

	onChildviewChange(value) {
		this.state.set("filterValue", value);
	},

	onToggleFilters() {
		this.state.set("showFilters", !this.state.get("showFilters"));
	},

	onSubmitForm() {
		this.state.set({
			loading: true,
			hasQuery: true
		});

		this.model
			.clear()
			.set({
				cptCode: this.state.get("cptFilter"),
				surgeon: this.state.get("providerFilter"),
				specialty: this.state.get("specialtyFilter")
			})
			.save(null, authHeaders())
			.catch(err => console.error("Error fetching results", err))
			.then(() => this.state.set("loading", false));
	},

	onClear() {
		this.state.set({
			hasQuery: false,
			cptFilter: null,
			providerFilter: null,
			specialtyFilter: null
		});
	},

	onCancel() {
		Radio.request("global", "navigate", "/");
	}
});
