const Marionette = require("backbone.marionette");
const CountrySelection = require("../../../entities/administration/poc_countries_config/collection");
const SelectView = require("../../../utils/select/view");
const FacilitySelectView = require("../../../utils/entity-select/facilities");
const TooltipBehavior = require("../../../behaviors/tooltip");

const Btns = [
	{
		"btnId": "save",
		"btnXtraCase": "",
		"btnName": "save",
		"btnTitle": "Save",
		"btnLabel": "Save"
	},
	{
		"btnId": "clear",
		"btnXtraCase": "",
		"btnName": "clear",
		"btnTitle": "Clear all data",
		"btnLabel": "Clear"
	},
	{
		"btnId": "cancel",
		"btnXtraCase": "",
		"btnName": "cancel",
		"btnTitle": "Cancel this screen",
		"btnLabel": "Exit Without Saving"
	}
];

module.exports = Marionette.StateView.extend({
	className: "flexIt flexIt-container",
	template: require("./template.hbs"),
	defaultState: {
		"loading": true
	},
	stateEvents: {
		"change": "render"
	},
	regions: {
		"selectField": "#selectField",
		"selectField2": "#selectField2",
		"toolTip": "#toolTip",
		"timeDatePicker": "#timeDatePicker",
		"entitySelect": ".r-facilities",
		"entitySelect2": ".r-facilities-2",
		"entitySelect3": ".r-facilities-3"
	},

	behaviors: {
		Tooltips: {
			behaviorClass: TooltipBehavior,
			options: {
				placement: "right"
			}
		}
	},

	onAttach() {
		this.loadData();
	},

	loadData() {
		this.Countries = new CountrySelection();
		this.Countries.fetch()
			.then(() => this.state.set("loading", false));
	},

	templateContext() {
		return {
			"Buttons": Btns
		};
	},

	onRender: function () {
		// $("[data-toggle=\"tooltip\"]").tooltip({"container":"body", "placement": "right", "html": true});
		if (!this.state.get("loading")) {
			const selectView = new SelectView({
				"collection": this.Countries,
				"ariaLabel": "specialtylabel",
				"size": 5
			});

			const selectView2 = new SelectView({
				"collection": this.Countries,
				"ariaLabel": "specialtylabel"
			});

			this.showChildView("selectField", selectView);
			this.showChildView("selectField2", selectView2);
			this.showChildView("entitySelect", new FacilitySelectView());
			this.showChildView("entitySelect2", new FacilitySelectView());
			this.showChildView("entitySelect3", new FacilitySelectView());
		}
	}
});
