const Marionette = require("backbone.marionette");
const Radio = require("backbone.radio");
const TabView = require("../../../components/tabs/view");

const CaseTabButtons = require("../../case/components/case_tab_buttons");

const tabs = {
	"tab0": "Patient And Procedure",
	"tab1": "Time And Staff",
	"tab2": "Intraoperative",
	"tab3": "Special Case Needs"
};

const PatientInformation = [
	{
		"type": function() { return "case/demographic-row";},
		"Cell1": {
			"label": "Patient Name",
			"data": "My Name"
		},
		"Cell2": {
			"label": "Gender",
			"data": "Male"
		}
	},
	{
		"type": function() { return "case/demographic-row";},
		"Cell1": {
			"label": "Age",
			"data": "72"
		},
		"Cell2": {
			"label": "Date of Birth",
			"data": "06/23/1954"
		}
	},

	{
		"type": function() { return "case/demographic-row";},
		"Cell1": {
			"label": "Provider",
			"data": "Provider John Smith"
		},
		"Cell2": {
			"label": "SSN",
			"data": "123-45-6789"
		}
	},
	{
		"type": function() { return "case/demographic-bigrow";},
		"Cell1": {
			"label": "Address",
			"data": "1313 Mockingbird Lane"
		}
	},
	{
		"type": function() { return "case/demographic-bigrow";},
		"Cell1": {
			"label": "City, State/Zip",
			"data": "Endicot City, Pa 17600, Lancaster County"
		}
	},
	{
		"type": function() { return "case/demographic-bigrow";},
		"Cell1": {
			"label": "Phone",
			"data": "Home: 111-555-1234, Cell: 111-555-4321, Work: 111-555-3321"
		}
	},
	{
		"type": function() { return "case/demographic-bigrow";},
		"Cell1": {
			"label": "Service Connected",
			"data": "US Dept. of the Navy"
		}
	},
	{
		"type": function() { return "case/demographic-bigrow";},
		"Cell1": {
			"label": "Environmental Factors",
			"data": "Nulla quis dui viverra, suscipit mauris eu, fermentum urna. Nunc sed augue posuere, tincidunt arcu at, fringilla velit. Ut imperdiet lacus et imperdiet cursus. Morbi in risus nulla. Fusce molestie vulputate sodales. Fusce vel interdum diam, quis semper est. Integer interdum mi felis, eget iaculis tellus consequat vitae. Aliquam vitae fermentum ligula."
		}
	}
];

const CaseFormFields = [
	{
		"col1Id": "CaseFld1",
		"col1Label": "CPT/Principal Procedure",
		"col1Hint": "Select CPT OR Principal Procedure",
		"col1Type": "select",
		"col1Help": "",

		"col2Id": "CaseFld2",
		"col2Label": "Laterality of Procedure",
		"col2Hint": "Enter Laterality of Procedure",
		"col2Type": "select",
		"col2Help": ""
	},
	{
		"col1Id": "CaseFld3",
		"col1Label": "CPT/Principal Procedure",
		"col1Hint": "Select CPT OR Principal Procedure",
		"col1Type": "select",
		"col1Help": "",

		"col2Id": "CaseFld4",
		"col2Label": "Principal Preoperative ICD Diagnosis Code",
		"col2Hint": "Enter Principal Preoperative ICD Diagnosis Code",
		"col2Type": "text",
		"col2Help": ""
	},
	{
		"col1Id": "CaseFld1",
		"col1Label": "CPT/Principal Procedure",
		"col1Hint": "Select CPT OR Principal Procedure",
		"col1Type": "select",
		"col1Help": "",

		"col2Id": "CaseFld2",
		"col2Label": "Laterality of Procedure",
		"col2Hint": "Enter Laterality of Procedure",
		"col2Type": "select",
		"col2Help": ""
	},
	{
		"col1Id": "CaseFld3",
		"col1Label": "CPT/Principal Procedure",
		"col1Hint": "Select CPT OR Principal Procedure",
		"col1Type": "select",
		"col1Help": "",

		"col2Id": "CaseFld4",
		"col2Label": "Principal Preoperative ICD Diagnosis Code",
		"col2Hint": "Enter Principal Preoperative ICD Diagnosis Code",
		"col2Type": "text",
		"col2Help": ""
	},
	{
		"col1Id": "CaseFld1",
		"col1Label": "CPT/Principal Procedure",
		"col1Hint": "Select CPT OR Principal Procedure",
		"col1Type": "select",
		"col1Help": "",

		"col2Id": "CaseFld2",
		"col2Label": "Laterality of Procedure",
		"col2Hint": "Enter Laterality of Procedure",
		"col2Type": "select",
		"col2Help": ""
	},
	{
		"col1Id": "CaseFld3",
		"col1Label": "CPT/Principal Procedure",
		"col1Hint": "Select CPT OR Principal Procedure",
		"col1Type": "select",
		"col1Help": "",

		"col2Id": "CaseFld4",
		"col2Label": "Principal Preoperative ICD Diagnosis Code",
		"col2Hint": "Enter Principal Preoperative ICD Diagnosis Code",
		"col2Type": "text",
		"col2Help": ""
	},
	{
		"col1Id": "CaseFld1",
		"col1Label": "CPT/Principal Procedure",
		"col1Hint": "Select CPT OR Principal Procedure",
		"col1Type": "select",
		"col1Help": "",

		"col2Id": "CaseFld2",
		"col2Label": "Laterality of Procedure",
		"col2Hint": "Enter Laterality of Procedure",
		"col2Type": "select",
		"col2Help": ""
	},
	{
		"col1Id": "CaseFld3",
		"col1Label": "CPT/Principal Procedure",
		"col1Hint": "Select CPT OR Principal Procedure",
		"col1Type": "select",
		"col1Help": "",

		"col2Id": "CaseFld4",
		"col2Label": "Principal Preoperative ICD Diagnosis Code",
		"col2Hint": "Enter Principal Preoperative ICD Diagnosis Code",
		"col2Type": "text",
		"col2Help": ""
	},
	{
		"col1Id": "CaseFld1",
		"col1Label": "CPT/Principal Procedure",
		"col1Hint": "Select CPT OR Principal Procedure",
		"col1Type": "select",
		"col1Help": "",

		"col2Id": "CaseFld2",
		"col2Label": "Laterality of Procedure",
		"col2Hint": "Enter Laterality of Procedure",
		"col2Type": "select",
		"col2Help": ""
	},
	{
		"col1Id": "CaseFld3",
		"col1Label": "CPT/Principal Procedure",
		"col1Hint": "Select CPT OR Principal Procedure",
		"col1Type": "select",
		"col1Help": "",

		"col2Id": "CaseFld4",
		"col2Label": "Principal Preoperative ICD Diagnosis Code",
		"col2Hint": "Enter Principal Preoperative ICD Diagnosis Code",
		"col2Type": "text",
		"col2Help": ""
	}
];

const Btns = [
	{
		"btnId": "saveCaseTab0",
		"btnXtraCase": "save-case",
		"btnName": "saveCaseNameTab0",
		"btnTitle": "Save this Case",
		"btnLabel": "Save Case"
	},
	{
		"btnId": "clearCaseTab0",
		"btnXtraCase": "",
		"btnName": "clearCaseNameTab0",
		"btnTitle": "Clear all data",
		"btnLabel": "Clear Case"
	},
	{
		"btnId": "cancelTab0",
		"btnXtraCase": "",
		"btnName": "cancelNameTab0",
		"btnTitle": "Cancel this screen",
		"btnLabel": "Exit Without Saving"
	}
];


const fieldSet = {
	"fldSetId": "CaseDataPatientInformationGroup",
	"fldSetDataTarget": "CaseDataPatientInformation",
	"fldSetLegend": "Patient Information"
};


module.exports = Marionette.StateView.extend({
	className: "flexIt flexIt-container",
	template: require("./template.hbs"),
	regions: {
		tabRegion: "#tab-tops",
		buttonRegion0: "#tabButtonsDiv",
		buttonRegion1: "#tabButtonsDiv",
		buttonRegion2: "#tabButtonsDiv",
		buttonRegion3: "#tabButtonsDiv",
		patientTab: "#tab0",
		timeStaffTab: "#tab1",
		intraOpTab: "#tab2",
		specialCaseTab: "#tab3"
	},

	ui: {
		XpandCollapseCaret: "#CaseDataPatientInformation"
	},

	templateContext() {
		fieldSet.fldSetData = PatientInformation;
		const data = {
			"Information": PatientInformation,
			"CaseFields": CaseFormFields,
			"Buttons": Btns,
			"FieldSet": fieldSet
		};
		return data;
	},

	onRender: function () {
		this.showChildView("tabRegion", new TabView({
			tabs,
			selected: "tab0"
		}));

		$("#CaseDataPatientInformation").collapse("show");
	},

	onChildviewTabSelected(tab) {
		this.state.set("selectedTab", tab);
	}
});
