"use strict";

const $        = require("jquery");
const _        = require("lodash");
const Backbone = require("backbone");
const hbs = require("hbsfy/runtime");

// Expose globals
global.$ = global.jQuery = $;
global._ = _;
global.Backbone = Backbone;

// Import Backbone plugins
require("backbone.marionette");
require("backbone.intercept");
require("backbone.sciatic");
require("marionette.stateview");

// Import Bootstrap scripts
require("bootstrap/dist/js/bootstrap");

require("./vendor/jquery-ui");
/* require("mdbootstrap/js/tether"); */
/* require("mdbootstrap/js/mdb"); */
const moment = require("moment/moment");
require("fullcalendar/dist/fullcalendar.min");
require("typeahead.js");

require("bootstrap-select");

require("jquery-mousewheel/jquery.mousewheel");

/* Setup a DateFormatter global for $.datetimepicker to use.

	 By default it wants php-date-formatter, but they provide an example
	 of replacing that with moment.  However, you need a DateFormmater
	 global constructor to exist at init time before you get to tell it
	 to use moment instead of php-date-formatter.
*/
window.DateFormatter = function () {};

const dtpInit = require("jquery-datetimepicker/jquery.datetimepicker");
dtpInit($); // This call add datetimepicker to the jQuery object.

$.datetimepicker.setDateFormatter({
	parseDate: function (date, format) {
		var d = moment(date, format);
		return d.isValid() ? d.toDate() : false;
	},

	formatDate: function (date, format) {
		return moment(date).format(format);
	}
});

$.datetimepicker.setLocale("en");

// Register hbs helpers
const helpers = require("./utils/hbs-helpers");
_.each(helpers, (fn, name) => hbs.registerHelper(name, (...args) => fn(...args)));

const partials = require("./partials/**/*.hbs", { mode: "hash" });
_.each(partials, (fn, name) => hbs.registerPartial(name, (...args) => fn(...args)));

// Start up the application
const App = require("./app");
window.app = new App();
window.app.start();
