const BaseModel = require("../../base/model");
const API       = require("../../../api");
const storage   = require("../../../utils/storage");

module.exports = BaseModel.extend({
  urlRoot: API.getURL("PatientSSN"),
  defaults: {
    "name": null,
    "dfn": null,
    "id": null
  },

  saveToLocalStorage() {

    storage.setItem("PatientName", this.get('name'));
    storage.setItem("PatientSSN", this.get('id'));
    storage.setItem("PatientDFN", this.get('dfn'));
  }

});
