const BaseModel = require("../../base/model");
const API       = require("../../../api");
const storage   = require("../../../utils/storage");

module.exports = BaseModel.extend({
  urlRoot: API.getURL("PatientLastFive"),
  defaults: [{
    "dfn": "",
    "name": "",
    "gender": "",
    "dob": "",
    "age": "",
    "ssn": "",
    "birthCity": "",
    "birthState": "",
    "provider": "",
    "roomBed": "",
    "currentRoom": "",
    "addrStreet1": "",
    "addrStreet2": "",
    "addrStreet3": "",
    "addrCity": "",
    "addrState": "",
    "addrZip": "",
    "addrCounty": "",
    "addrProvince": "",
    "addCountry": "",
    "addrForeignPostCode": "",
    "addrZipExt": "",
    "resPhoneNum": "",
    "workPhonNum": "",
    "email": "",
    "kName": "",
    "kRelationship": "",
    "kAddressPatientAddress": "",
    "kStreet1": "",
    "kStreet2": "",
    "kStreet3": "",
    "kCity": "",
    "kState": "",
    "kZip": "",
    "kPhone": "",
    "scYesNo": "",
    "scAwardDate": ""
  }],


  saveToLocalStorage() {
    storage.setItem("PatientName", this.get('name'));
    storage.setItem("PatientLast5", this.get('id'));
    storage.setItem("PatientDFN", this.get('dfn'));
  }
});
