/** room model **/
const Backbone = require("backbone");
const API      = require("../../api");
const authHeaders = require("../../utils/authHeaders");
const EventsCollection = require("./events/collection");

module.exports = Backbone.Model.extend({
	idAttribute: "ien",
	urlRoot: API.getURL("Rooms"),
	defaults: {
		ien: null,
		ix: null,
		name: null,
		contact: null,
		another_number: null,
		last_number: null,
		location: null
	},
	fetchEvents(event_date = new Date()) {
		this.eventsCollection = new EventsCollection([], { room_id: this.get("ien"), date: event_date.toISOString().split("T")[0] });
		return this.eventsCollection.fetch(authHeaders());
	},
	toJSON() {
		const original = Backbone.Model.prototype.toJSON.apply(this, arguments);

		return Object.assign({}, original, {
			_events: this.eventsCollection ? this.eventsCollection.toJSON() : []
		});
	}
});