const BaseModel = require("../base/model");
const API       = require("../../api");

module.exports = BaseModel.extend({
	idAttribute: "dfn",
	urlRoot: API.getURL("PatientId"),
	defaults: {
		"PatientAllModel": "",
		"dfn": "",
		"name": "",
		"gender": "",
		"dob": "",
		"age": "",
		"ssn": "",
		"birthCity": "",
		"birthState": "",
		"provider": "",
		"roomBed": "",
		"currentRoomBed": "",
		"addrStreet1": "",
		"addrStreet2": "",
		"addrStreet3": "",
		"addrCity": "",
		"addrState": "",
		"addrZip": "",
		"addrCounty": "",
		"addrProvince": "",
		"addCountry": "",
		"addrForeignPostCode": "",
		"addrZipExt": "",
		"resPhoneNum": "",
		"workPhonNum": "",
		"email": "",
		"kName": "",
		"kRelationship": "",
		"kAddressPatientAddress": "",
		"kStreet1": "",
		"kStreet2": "",
		"kStreet3": "",
		"kCity": "",
		"kState": "",
		"kZip": "",
		"kPhone": "",
		"scYesNo": "",
		"scAwardDate": ""
	},

	isLoaded() {
		if (!this.get("name")) return false;
		return true;
	},

	computed: {
		lastFive: {
			depends: ["name", "dfn", "ssn"],
			get: function (fields) {
				return fields.name.slice(0,1) + fields.ssn.slice(-4);
			},
			set:function(fields) {
				fields.lastFive = fields.name.slice(0,1) + fields.ssn.slice(-4);
			}
		},
		addrCityStateZip: {
			depends: ["addrCity", "addrState", "addrZip"],
			get(rawFields) {
				let fields = [];
				if (rawFields.addrCity) {
					fields.push(rawFields.addrCity);
				}
				if (rawFields.addrState) {
					fields.push(rawFields.addrState);
				}
				if (rawFields.addrZip) {
					fields.push(rawFields.addrZip);
				}
				console.log("fields:", fields, rawFields);
				return fields.join(", ");
			}
		}
	}
});
