const BaseModel = require("../base/model");
const API       = require("../../api");
const storage   = require("../../utils/storage");


module.exports = BaseModel.extend({
	urlRoot: API.getURL("Authenticate"),
	defaults: {
		"ien": "",
		"firstname": "",
		"lastname": "",
		"roles": [],
		"success": null,
		"message": null,
		"token": null,
		"user_info": {
			"duz": "",
			"name": "",
			"usrcls": "",
			"cansign": false,
			"isprovider": false,
			"orderrole": false,
			"noorder": "",
			"dtime": "",
			"countdown": "",
			"enableverify": "",
			"notifyapps": "",
			"msghang": "",
			"domain": "",
			"service": "",
			"autosave": "",
			"inittab": "",
			"lasttab": "",
			"webaccess": "",
			"allowhold": "",
			"isrpl": "",
			"rpllist": "",
			"cortabs": "",
			"rpttab": "",
			"stanum": "",
			"gecstatus": "",
			"prodacct": false
		}
	},

	saveToLocalStorage() {
		storage.setItem("access_token", this.get("token"));
		storage.setItem("firstname", this.get("firstname"));
		storage.setItem("lastname", this.get("lastname"));
		storage.setItem("roles", this.get("roles"));
		storage.setItem("ien", this.get("ien"));
		storage.setItem("user_info", this.get("user_info"));
	}
});
