const BaseModel = require("../base/model");
const API = require("../../api");
const _ = require("underscore");
const RoBaseCollection = require("../ro-base/collection");
const DispositionModel = require("./disposition_model.js");

const list_types = {
	"People": {},
	"Specialty": {},
	"ICDCodes": {},
	"RoomType": {"id": "ien"},
	"ORRooms": {},
	"CaseClosureReasons": {},
	"CaseCancelReasons": {},
	"PostopCare": {model: DispositionModel},
	"Positions": {},
	"PlannedImplants": {},
	"SpecialEquipment": {},
	"SpecialSupplies": {},
	"SpecialInstruments": {},
	"PharmacyItems": {},
	"HospitalLocations": {},
	"AttendingCodes": {},
	"AneSuperCodes": {},
	"AsaClass": {},
	"MedicalSpecialty": {}
};

const collections = {};

for (let list in list_types) {
	let list_type = list_types[list];
	if (! list_types.hasOwnProperty(list)) continue;

	let model = list_type.model || BaseModel;

	const collection_opts = {
		url: API.getURL(list),
		model: model
	};

	if (list_type.id) {
		collection_opts.modelId = list_type.id;
	}

	let collection = RoBaseCollection.extend(collection_opts);
	collections[list] = collection;
}

module.exports = collections;
