const Backbone = require("backbone");
const BaseModel = require("../base/model");
const API = require("../../api");
const _ = require("underscore");
const Patient = require("../patient/model");
const authHeaders = require("../../utils/authHeaders");
const Radio = require("backbone.radio");
const RoBaseCollection = require("../ro-base/collection");

const field_types = {
	"CaseScheduleType": {},
	"CaseType": {},
	"CaseStatus": {},
	"PreOpInfection": {},
	"AnesthesiaTechnique": {},
	"AdmissionStatus": {},
	"IntraoperativeXrays": {},
	"BloodTypeXmatch": {},
	"CancelTimeframe": {},
	"BloodProductInfo": {},
	"ProcedureLaterality": {},
	"diabetesMellitusChronic": {},
	"diabetesMellitusPreopMgmt": {},
	"tobaccoUse": {},
	"tobaccoUseTimeframe": {},
	"etohGTTwoDrinksPerDay": {},
	"positiveDrugScreening": {},
	"dyspnea": {},
	"preopSleepApnea": {},
	"dnrStatus": {},
	"preopFunctHealthStatus": {},
	"residence30DaysPreop": {},
	"ambulationDevicePreop": {},
	"homeless": {},
	"ventilatorDependent": {},
	"historyOfCOPD": {},
	"currentPneumonia": {},
	"ascites": {},
	"esophagealVarices": {},
	"congestiveHeartFailurePreop": {},
	"priorMI": {},
	"pci": {},
	"anginaSeverity": {},
	"anginaTimeframe": {},
	"hypertension": {},
	"priorSurgSameOpField": {},
	"hxRadRxPlannedSurgField": {},
	"cvdRepair": {},
	"donorSerologyHIV": {},
	"peripheralArterialDisease": {},
	"renalFailure": {},
	"impairedSensorium": {},
	"coma": {},
	"historyOfCVD": {},
	"impairedCognitiveFunction": {},
	"nutritionalImmuneOther": {},
	"openWound": {},
	"chronicSteroidUse": {},
	"tenPercDecrWeightLoss": {},
	"bleedingDisorders": {},
	"bleedingRiskDueToMed": {},
	"transfusionGTFourRBCUnits": {},
	"chemoForMaligLastNinety": {},
	"radiotherapyLastNinety": {},
	"preopSepsis": {},
	"pregnancy": {}
};

const collections = {};

for (let field in field_types) {
	let fieldOpts = field_types[field];

	const collectionOpts = {
		url: API.getURL(field),
		model: BaseModel
	};

	if (fieldOpts.id) {
		collectionOpts.modelId = attrs => attrs[fieldOpts.id];
	} else {
		collectionOpts.modelId = attrs => attrs["code"];
	}

	let collection = RoBaseCollection.extend(collectionOpts);
	collections[field] = collection;
}

module.exports = collections;
