const BaseModel = require("../base/model");
const API       = require("../../api");
const storage   = require("../../utils/storage");

module.exports = BaseModel.extend({
	urlRoot: API.getURL("Facilities"),
	defaults: {
		"_id": "",
		"stationID": "",
		"facilityName": ""
	},

	saveToLocalStorage() {
		storage.setItem("stationID", this.get("stationID"));
		storage.setItem("facilityName", this.get("facilityName"));
	}
});
