const BaseModel = require("../../base/model");
const API       = require("../../../api");
const storage   = require("../../../utils/storage");

module.exports = BaseModel.extend({
	urlRoot: API.getURL("FacilitiesDetails"),
	idAttribute: "stationID",
	defaults: {
		"_id": "",
		"stationID": "",
		"facilityName": "",

		"complexityLevel": "",
		"facilitySize": "",
		"state": "",
		"visn": "",
		"ipAddress": "",
		"port": ""
	},

	saveToLocalStorage() {
		storage.setItem("stationID", this.get("stationID"));
		storage.setItem("facilityName", this.get("facilityName"));
		storage.setItem("complexityLevel", this.get("complexityLevel"));
		storage.setItem("facilitySize", this.get("facilitySize"));
		storage.setItem("state", this.get("state"));
		storage.setItem("visn", this.get("visn"));
		storage.setItem("ipAddress", this.get("ipAddress"));
		storage.setItem("port", this.get("port"));
	}
});
