const _				 = require("underscore");
const API            = require("../../../api");
const BaseCollection = require("../../base/collection");
const ViewAccessModel  = require("./model");

module.exports = BaseCollection.extend({
	"url": API.getLocalURL("ViewRoles"),
	"model": ViewAccessModel,

	getPermittedForUser(user) {
		if (!user) { return []; }

		const userRoles = user.get('roles');

		// Return only models which have overlapping roles with the provided user
		return this.filter((model) => _.intersection(model.get('roles'), userRoles).length)
			.map(model => model.get('viewName'));
	}
});
