const BaseModel = require("../../base/model");
const API      = require("../../../api");

module.exports = BaseModel.extend({
	idAttribute: "id",
	urlRoot: API.getURL("CPT"),
	defaults: {
		id: null,
		cptCode: null,
		name: null,
		cptCategory: null,
		source: null,
		inactive: null
	},
	computed: {
		cptName: {
			depends: ["cptCode", "name"],
			get(rawFields) {
				return rawFields.cptCode + " - " + rawFields.name;
			}
		}
	}
});
