const Backbone = require("backbone");
const manageToken = require("../../utils/manageToken");

/* Note on validation:

All instances of base model that implement validation should do so by
returning an array for errors.  The contents of that array be two
element arrays consisting of field name and an error message.

The purpose of using an array instead of an object as dict is so that
a single field can have multiple errors.

Example:
[
	["ien", "must be set"],
	["dateOfProcedure", "must be set"],
	["scheduledStartTime", "must be earlier than Scheduled End Time"],
	["scheduledEndTime", "must be later than Scheduled Start Time"],
	["password", "must be greater than 10 characters"],
	["password", "must contain both upper and lower case"]
]


*/

module.exports = Backbone.Model.extend({
	initialize() {
		manageToken(this);
		this.computedFields = new Backbone.ComputedFields(this);
	}
});
