const BaseModel = require("../../../base/model");
const API       = require("../../../../api");
const _ = require("underscore");

module.exports = BaseModel.extend({

	idAttribute: "_id",
	urlRoot: API.getURL("SSLQISearch"),

	defaults: {
		"_id": null,
		"vistaId": null,
		"itemCategory": null,
		"itemType": null,
		"itemSpecialtyType": null,
		"item": null,
		"inventoryNumber": null,
		"classification": null,
		"itemLocationFacility": null,
		"itemLocationRoom": null,
		"itemStatus": null,
		"itemTypeQuality": null,
		"size": null,
		"itemUsage": null,
		"specialty": [],
		"manufacturer": null,
		"vendor": null,
		"model": null,
		"serialNumber": null,
		"mobilityIndicator": null,
		"roomNumber": null,
		"reqRoomSize": null,
		"shields": null,
		"environmentalInformation": null,
		"availability": null,
		"blockedTimes": null,
		"attributesTags": null,
		"limitations": null,
		"safetyMeasureThresholdMin": null,
		"safetyMeasureThresholdMax": null,
		"comments": null,
		"poc": null
	},

	parse(data) {
		return _.isArray(data) ? { results: data } : data;
	}
});
