const BaseModel = require("../../../base/model");
const API       = require("../../../../api");
const _ = require("underscore");

module.exports = BaseModel.extend({

	idAttribute: "_id",
	urlRoot: API.getURL("SSLQIReservation"),

	defaults: {
		"_id": null,
		"vistaId": null, // req
		"classification": null, // req
		"room": null,
		"caseId": null, //req
		"requester": null,
		"startDT": null, // req
		"endDT": null, // req
		"comments": null
	},

	parse(data) {
		return _.isArray(data) ? { results: data } : data;
	}
});
