const BaseModel = require("../../base/model");
const API       = require("../../../api");
const _ = require("underscore");

module.exports = BaseModel.extend({
	idAttribute: "_id",
	urlRoot: API.getURL("SSLQI"),

	validate(attributes) {
		const errors = [];
		const requiredProps = ["item", "itemCategory", "itemType", "inventoryNumber", "classification", "specialty"];

		requiredProps.forEach(prop => _.isUndefined(attributes[prop]) && errors.push([prop, "This field is required."]));

		if (_.isEmpty(errors)) { return; }
		return errors;
	},

	parse(data) {
		return _.isArray(data) ? { results: data } : data;
	}
});
