const BaseModel = require("../../../base/model");
const API       = require("../../../../api");
const _ = require("underscore");

module.exports = BaseModel.extend({

	idAttribute: "_id",
	urlRoot: API.getURL("SSLQISearch"),

	defaults: {
		"_id": null,
		"vistaId": null,
		"itemCategory": null,
		"itemType": null
	},

	parse(data) {
		return _.isArray(data) ? { results: data } : data;
	}
});
