const _        = require("lodash");
const Backbone = require("backbone");
const Marionette = require("backbone.marionette");
const classNames = require("classnames");
const RenderClassnames = require("../../behaviors/render-classnames");

const TabView = Marionette.View.extend({
	tagName: "li",
	template: require("./template.hbs"),

	className() {
		return classNames("tab-li", {
			active: this.model.get("selected")
		});
	},

	triggers: {
		"click": "click"
	},

	modelEvents: {
		"change:selected": "render"
	},

	behaviors: { RenderClassnames }
});

module.exports = Marionette.CollectionView.extend({
	tabs: {},

	initialize() {
		const collection = new Backbone.Collection();
		collection.reset(_.map(this.getOption("tabs"), (value, key) => ({
			id: key,
			label: value
		})));

		if (this.getOption("selected")) {
			collection.get(this.getOption("selected")).set("selected", true);
		}

		this.collection = collection;
	},

	tagName: "ul",
	className: "tab-links tab-to-body-space",
	childView: TabView,

	onChildviewClick(childView) {
		this.setSelected(childView.model.get("id"));
	},

	setSelected(id) {
		const selected = this.collection.get(id);
		if (!selected) { throw new Error(`No tab with id: "${id}".`); }

		this.collection.findWhere({ selected: true }).set({ selected: false });
		selected.set({ selected: true });
		this.triggerMethod(`tab:selected:${id}`);
		this.triggerMethod("tab:selected", id);
	},

	getSelected() {
		return this.collection.findWhere({ selected: true }).get("id");
	}
});
