const Backbone = require("backbone");
const Handlebars = require("handlebars");
const Marionette = require("backbone.marionette");

/* FoldingView is a wrapping view that has a title and can roll up
 * into a folded view.
 *
 * It can contain either a childView or be given a template (anything
 * that is callable with a data object as sole parameter and will return
 * HTML).
 */

const GenericTemplateView = Marionette.View.extend({
	modelEvents: {
		change: "render"
	},
	onRender() {
	}
});

module.exports = Marionette.View.extend({
	template: require("./folding_view.hbs"),
	tagName: "fieldset",
	ui: {
		titleHeader: ".folding-title",
		titleCaret: ".folding-title i"
	},
	regions: {
		containedFields: ".contained-fields"
	},
	events: {
		"click @ui.titleHeader": "handleExpandCollapse"
	},
	handleExpandCollapse() {
		this.containedView.$el.toggle();
		this.getUI("titleCaret").toggleClass("fa-caret-down fa-caret-right");
	},
	initialize(options) {
		console.log("FoldingView initialize");
		if (options.contents) {
			this.containedView = new GenericTemplateView({
				template: options.contents,
				model: this.model
			});
		} else if (options.containedView) {
			this.containedView = options.containedView;
		} else {
			throw new Error("FoldingView options must contain either containedView or contents key.");
		}
	},
	onRender() {
		console.log("FoldingView onRender - ", this.getOption("expand") ? "expand" : "default");

		this.getUI("titleHeader")
			.prepend(this.getOption("title"));

		this.showChildView("containedFields", this.containedView);
		if (this.getOption("expand")) {
			this.containedView.$el.toggle(true);
			this.getUI("titleCaret").toggleClass("fa-caret-down fa-caret-right");
		}
		else {
			this.containedView.$el.toggle();
		}
	}
});
