const Marionette = require("backbone.marionette");

module.exports = Marionette.Behavior.extend({
	defaults: {
		selector: "[data-toggle='tooltip']",
		options: {}
	},

	initialize() {
		this.defaultOptions = {
			container: "body",
			placement: "bottom",
			html: true
		};
	},

	ui() {
		return {
			widgets: this.getOption("selector")
		};
	},

	onDomRefresh() {
		const opts = Object.assign({}, this.defaultOptions, this.getOption("options"));
		this.getUI("widgets").tooltip(opts);
	}
});
