const $ = require("jquery");
const Marionette = require("backbone.marionette");

/**
 * This behavior can be attached to any view which needs
 * to be able to programmatically expand or collapse the
 * sidebar. Currently only needed in the sidebar view.
 */
module.exports = Marionette.Behavior.extend({
	initialize() {
		this.hiddenClass = "hide-sidebar";
		this.$root = $("body");
	},

	triggers: {
		"click .js-sidebar-collapse": "sidebar:collapse",
		"click .js-sidebar-expand": "sidebar:expand",
		"click .js-sidebar-toggle": "sidebar:toggle"
	},

	onSidebarCollapse() {
		this.$root.addClass(this.hiddenClass);
	},

	onSidebarExpand() {
		this.$root.removeClass(this.hiddenClass);
	},

	onSidebarToggle() {
		this.$root.toggleClass(this.hiddenClass);
	}
});
