const mn = require("backbone.marionette");

module.exports = mn.Behavior.extend({
	defaults: {
		selector: ".selectpicker",
		options: {}
	},

	ui() {
		return {
			widgets: this.getOption("selector")
		};
	},

	getElems() {
		return (this.getOption("selector") === "this") ? this.view.$el : this.getUI("widgets");
	},

	onDomRefresh() {
		const options = this.getOption("options");
		this.getElems().selectpicker(options);
	},

	onSelectpickerUpdate() {
		this.getElems().selectpicker("render");
	},

	onBeforeDetach() {
		this.getElems().selectpicker("destroy");
	}
});
