const _ = require("underscore");
const Marionette = require("backbone.marionette");

/**
 * By default, Backbone doesn't re-evaluate classNames on subsequent
 * renders. This is a small patch to ensure that everytime a view is
 * rendered, it's classNames are re-calculated.
 */
module.exports = Marionette.Behavior.extend({
	onRender() {
		this.$el.attr("class", _.result(this.view, "className"));
	}
});
