"use strict";
const config = require("./env.json");

let API_Base = config.NODE_API_EXTERNAL;
console.log("ENV - ", config.NODE_ENV);
if ("develop" == config.NODE_ENV) {
	API_Base = config.NODE_API_INTERNAL;
}
console.log("API_Base - ", API_Base);

/**
 * Here's where any constants for the API and non API URL's should be going
 **/


const GenericHelpURL = "http://URL                   /pm/iehr/vista_evolution/eHMP/Help_Wiki/Wiki%20Page%20Library/Accessing%20the%20eHMP%20Application.aspx";
const APIRoutes = {

	// Base
	"API_Base": API_Base,

	// API calls below here DO NOT requre access token
	"Authenticate": "authenticate",
	"Facilities": "facilities",

	// API calls here are local files, no access token or API_Base required
	"ViewRoles": "/data_files/view_roles_map.json",
	"SSLQIs": "/data_files/sslqi.json",
	"POC_Countries": "/data_files/poc_countries.json",
	"SearchBy": "/data_files/search-by.json",
	"CaseByProviderLocal": "/data_files/cases-provider.json",
	"ProviderWorkTimesLocal": "/data_files/provider-work-times.json",
	"AllProviderWorkTimesLocal": "/data_files/all-provider-work-times.json",


	// API calls below here require access token
	"FacilitiesDetails": "v1/facilities",

	"PatientAll": "v1/patient/all",
	"PatientLastFive": "v1/patient/five/",
	"PatientId": "v1/patient/",
	"PatientSSN": "v1/patient/ssn/",
	"PatientSurgeryDetails": "/v1/surgery/",

	"Case": "v1/cases",
	"CaseSearch": "v1/cases/search",
	"CaseByID":	"v1/cases/",
	"ExtendedCase": "v1/cases/extend",
	"ListRoleNames": "v1/roles",
	"ListKeys": "v1/roles/list/keys",
	"Rooms": "v1/room/all",
	"CasesForRoom": "v1/cases/room/:roomid",

	"CPT": "v1/cpt/",
	"CPTDuration": "v1/cpt/config/duration/",
	"CPTDurationSearch": "v1/cpt/config/duration/search",
	"CPTDurationCalculate": "v1/cpt/config/duration/calculate",

	"ListRoles": "v1/roles",
	"SSLQIReservation":"v1/sslqi/reservation",
	"SSLQISearch": "v1/sslqi/search",
	"SSLQI": "v1/sslqi",

	// This is the list of Rooms
	"RoomConfig": "v1/room/all",
	"RoomEvents": "v1/room/or/events/",
	// This is the configs
	"AdminRoomTypeConfig": "v1/specialty/room/config/",

	"CaseScheduleType": "v1/field/caseScheduleType",
	"PreOpInfection": "v1/field/preOpInfection",
	"AnesthesiaTechnique": "v1/field/anesthesiaTechnique",
	"AdmissionStatus": "v1/field/admissionStatus",
	"IntraoperativeXrays": "v1/field/intraoperativeXrays",
	"BloodTypeXmatch":    "v1/field/bloodTypeXmatch",
	"CancelTimeframe": "v1/field/cancelTimeframe",
	"BloodProductInfo": "v1/field/bloodProductInfo",
	"ProcedureLaterality": "v1/field/procedureLaterality",
	"CaseType": "v1/field/case_type",
	"CaseStatus": "v1/field/case_status",
	"CaseByProvider": "v1/cases/provider",
	"Provider": "v1/provider",

	"ambulationDevicePreop": "v1/field/ambulation_device",
	"anginaSeverity": "v1/field/angina_severity",
	"anginaTimeframe": "v1/field/angina_timeframe",
	"ascites": "v1/field/ascites",
	"bleedingDisorders": "v1/field/bleeding_disorders",
	"cardiac": "v1/field/cardiac",
	"central_nerv_sys_illness": "v1/field/central_nerv_sys_illness",
	"chronicSteroidUse": "v1/field/chronic_steroid_use",
	"coma": "v1/field/coma",
	"congestiveHeartFailurePreop": "v1/field/congestive_heart_failure_preop",
	"historyOfCOPD": "v1/field/copd_history",
	"currentPneumonia": "v1/field/current_pneumonia",
	"diabetesMellitusPreopMgmt": "v1/field/diabetes_mellitus",
	"diabetesMellitusChronic": "v1/field/diabetes_mellitus",
	"disseminated_cancer": "v1/field/disseminated_cancer",
	"dnrStatus": "v1/field/dnr_status",
	"donorSerologyHIV": "v1/field/donor_serology",
	"dyspnea": "v1/field/dyspnea",
	"esophagealVarices": "v1/field/esophageal_varices",
	"preopFunctHealthStatus": "v1/field/functional_health_status",
	"gastrointestinal": "v1/field/gastrointestinal",
	"general": "v1/field/general",
	"hair_removal_method": "v1/field/hair_removal_method",
	"hemiplegia_hemiparesis": "v1/field/hemiplegia_hemiparesis",
	"hepatobiliary": "v1/field/hepatobiliary",
	"historyOfCVD": "v1/field/history_of_cvd",
	"cvdRepair": "v1/field/history_of_cvd",
	"homeless": "v1/field/homeless",
	"hxRadRxPlannedSurgField": "v1/field/hx_rad_rx_planned_surg_field",
	"hypertension": "v1/field/hypertension",
	"impairedCognitiveFunction": "v1/field/impaired_cognitive_function",
	"impairedSensorium": "v1/field/impaired_sensorium",
	"chemoForMaligLastNinety": "v1/field/malig_chemo",
	"bleedingRiskDueToMed": "v1/field/medication_bleeding_risk",
	"nutritionalImmuneOther": "v1/field/nutritional_immune_other",
	"on_dialysis": "v1/field/on_dialysis",
	"openWound": "v1/field/open_wound",
	"packing": "v1/field/packing",
	"patient_edu_assessment": "v1/field/patient_edu_assessment",
	"pci": "v1/field/pci",
	"peripheralArterialDisease": "v1/field/peripheral_arterial_disease",
	"positiveDrugScreening": "v1/field/positive_drug_screening",
	"pregnancy": "v1/field/pregnancy",
	"preopSepsis": "v1/field/preop_sepsis",
	"preopSleepApnea": "v1/field/preop_sleep_apnea",
	"priorMI": "v1/field/prior_mi",
	"priorSurgSameOpField": "v1/field/prior_surg_same_op_field",
	"pulmonary": "v1/field/pulmonary",
	"radiotherapyLastNinety": "v1/field/radio_therapy_last_ninety",
	"renal": "v1/field/renal",
	"renalFailure": "v1/field/renal_failure",
	"residence30DaysPreop": "v1/field/residence",
	"rest_pain_gaingrene": "v1/field/rest_pain_gaingrene",
	"tenPercDecrWeightLoss": "v1/field/ten_perc_weight_loss",
	"tobaccoUseTimeframe": "v1/field/tobacco_timeframe",
	"tobaccoUse": "v1/field/tobacco_use",
	"transfusionGTFourRBCUnits": "v1/field/transfusion_gt_four_rbcs",
	"tumor_involving_cns": "v1/field/tumor_involving_cns",
	"etohGTTwoDrinksPerDay": "v1/field/two_drinks_day",
	"vascular": "v1/field/vascular",
	"ventilatorDependent": "v1/field/ventilator_dependent",
	"wound_classification": "v1/field/wound_classification",

	"People": "v1/list/people/",
	"Specialty": "v1/list/specialty/",
	"RoomType": "v1/list/or/types",
	"ORRooms": "v1/list/or",
	"CaseClosureReasons": "v1/list/closureReasons",
	"CaseCancelReasons": "v1/list/cancelReasons",
	"PostopCare": "v1/list/postopCare",
	"Positions": "v1/list/positions",
	"PlannedImplants": "v1/list/plannedImplants",
	"SpecialEquipment": "v1/list/special/equipment",
	"SpecialSupplies": "v1/list/special/supplies",
	"SpecialInstruments": "v1/list/special/instruments",
	"PharmacyItems": "v1/list/pharmacyItems",
	"HospitalLocations": "v1/list/hospitalLocations",
	"AttendingCodes": "v1/list/attendingCodes",
	"AneSuperCodes": "v1/list/aneSuperCodes",
	"AsaClass": "v1/list/asaClass",
	"ICDCodes": "v1/list/icd",
	"MedicalSpecialty": "v1/list/medicalSpecialty",
	"Notifications": "v1/notification",
	"DurationReportQuery": "v1/cpt/config/duration/search"




};

const getLocalURL = function(apiName) {
	return APIRoutes[apiName];
};

const getURL = function(apiName, p1) {
	if (typeof APIRoutes[apiName] === "undefined") {
		throw new Error("API key " + apiName + " not found.");
	}

	let url = APIRoutes[apiName];
	const sep = ("/" === url.slice(-1)) ? "" : "/";
	const localURL = (0 === url.indexOf("/data_files"));
	if (!localURL) {
		url = APIRoutes.API_Base + APIRoutes[apiName] + (p1 ? `${sep}${p1}` : "");
	}
	return url;
};

module.exports = {
	getLocalURL: getLocalURL,
	getURL: getURL,
	GenericHelpURL: GenericHelpURL
};
