"use strict";
const $ = require("../config.js");
const Version_json = {
	"name": "VistA SUITE v",
	"appversion": "0.22.1",
	"build": " alpha ",
	"dateStamp": "",
	"jenkins-project-name": "JENKINSPROJECTNAME",
	"jenkins-build-number": "JENKINSBUIDNUMBER"
};

const SrcPath = $.config.envPath;
const VersionFileName = "version.json";
const VersionFilePath = SrcPath + "/" + VersionFileName;

const string_src = function(filename, string) {
	var src = require('stream').Readable({ objectMode: true })
	src._read = function () {
		this.push(new $.gutil.File({
			cwd: "",
			base: "",
			path: filename,
			contents: new Buffer(string)
		}))
		this.push(null)
	}
	return src
};

const createVersionFile = function() {
	console.log("Creating Version File");
	const sBuf = JSON.stringify(Version_json);
	return string_src(VersionFileName, sBuf)
		.pipe($.gulp.dest(SrcPath + "/"));
};

const ckFileExistance = function() {
	$.fs.stat(VersionFilePath, function(err, stat) {
		if(err == null) {
			console.log("File exists");
		} else {
			createVersionFile();
		}
	});
};

const BumpPatch = function() {
	var d = new Date();
	var n = d.toLocaleString();
	ckFileExistance();

	$.gulp.src(VersionFilePath, {base: "./"})
	.pipe($.bump({key: "appversion", type:"patch"}))
	.pipe($.jsonModify({key:"dateStamp", value: n}))
	.pipe($.gulp.dest("./"));
};

const BumpMinor = function() {
	var d = new Date();
	var n = d.toLocaleString();
	ckFileExistance();

	$.gulp.src(VersionFilePath)
	.pipe($.bump({key: "appversion", type:"minor"}))
	.pipe($.jsonModify({key:"dateStamp", value: n}))
	.pipe($.gulp.dest("./"));
};

$.gulp.task(
	"bump",
	"runs Bumps version file",
	[],
	BumpPatch
);
