"use strict";
process.env.NODE_ENV = 'test';
var chai = require('chai');
var chaiHttp = require('chai-http');
var server = require('../index');
var should = chai.should();
const authenticate = require('./test_config');

chai.use(chaiHttp);

let testId;

let testData =   {
    "vistaId": "3",
    "classification": "Equipment",
    "room": "2",
    "caseId": "400",
    "requester": "VS2017",
    "startDT": "2017-10-10T21:03:00.000Z",
    "endDT": "2017-10-10T22:30:03.000Z",
    "comments": "Need this equipment"
};


let searchCriteria =   {
    "vistaId": "3",
    "classification": "Equipment"
};

describe('Manage SSLQI Reservation transactions', function() {
    this.timeout(0);


    it('Retrieves SSLQI Reservation. GET /v1/sslqi/reservation', function(done){
        authenticate(function(token){
            "use strict";
            chai.request(server)
                .get('/v1/sslqi/reservation')
                .set('Authorization', token)
                .end(function(err,response){
                    response.should.have.status(200);
                    response.should.be.json;
                    response.body.should.be.a('array');
                    done();
                });
        })
    });

/*
it('Create new SSLQI Reservation. POST /v1/sslqi/reservation', function(done){
    authenticate(function(token){
        "use strict";
        chai.request(server)
            .post('/v1/sslqi/reservation')
            .set('Authorization', token)
            .send(testData)
            .end(function(err,response){
                response.should.have.status(200);
                response.should.be.json;
                testData = response.body;
                testId = response.body._id;
                done();
            });
    })
});

it('Edits an existing SSLQI Reservation configuration. PUT /v1/sslqi/reservation/:id', function(done){
    authenticate(function(token){
        "use strict";
        testData.comments = "new comment";
        chai.request(server)
            .put('/v1/sslqi/reservation/' + testId)
            .set('Authorization', token)
            .send(testData)
            .end(function(err,response){
                response.should.have.status(200);
                response.should.be.json;
                done();
            });
    })
});

it('Gets an SSLQI Reservation by search criteria. POST /v1/sslqi/reservation/search', function(done){
    authenticate(function(token){
        "use strict";
        chai.request(server)
            .post('/v1/sslqi/reservation/search')
            .set('Authorization', token)
            .send(searchCriteria)
            .end(function(err,response){
                response.should.have.status(200);
                response.should.be.json;
                //response.body.should.be.a('array');
                done();
            });
    })
});

it('Retrieves an existing SSLQI Reservation by _id. GET /v1/sslqi/reservation/:id', function(done){
    authenticate(function(token){
        "use strict";
        chai.request(server)
            .get('/v1/sslqi/reservation/' + testId)
            .set('Authorization', token)
            .end(function(err,response){
                response.should.have.status(200);
                response.should.be.json;
                response.should.be.a('object');
                done();
            });
    })
});

it('DELETE an existing SSLQI Reservation by ID. DELETE /v1/sslqi/reservation/:id', function(done){
    authenticate(function(token){
        "use strict";
        chai.request(server)
            .delete('/v1/sslqi/reservation/' + testId)
            .set('Authorization', token)
            .end(function(err,response){
                response.should.have.status(200);
                done();
            });
    })
});
*/
});
