"use strict";
process.env.NODE_ENV = 'test';
var chai = require('chai');
var chaiHttp = require('chai-http');
var server = require('../index');
var should = chai.should();
const authenticate = require('./test_config');

chai.use(chaiHttp);

let testId, token;

let initialReservation = {
    "vistaId": "3",
    "classification": "Equipment",
    "room": "2",
    "caseId": "400",
    "requester": "VS2017",
    "startDT": "2017-10-10T21:03:00.000Z",
    "endDT": "2017-10-10T22:30:03.000Z",
    "comments": "Need this equipment"
};

let testData = {
    "initialReservationId": "",
    "caseId": "401",
    "requester": "VS2017",
    "startDT": "2017-10-10T21:03:00.000Z",
    "endDT": "2017-10-10T22:30:03.000Z",
    "comments": "Need this equipment more"
};


let searchCriteria = {
    "caseId": "401"
};

describe('Manage SSLQI Release Request transactions', function () {
    this.timeout(0);

    before(function (done) {
        console.log("BEFORE");
        authenticate(function (t) {
            token = t;
            done();
            /*
            chai.request(server)
                .post('/v1/sslqi/reservation')
                .set('Authorization', t)
                .send(initialReservation)
                .end(function (err, response) {
                    initialReservation = response.body;
                    testData.initialReservationId = initialReservation._id;
                    console.log("BEFORE-COMPLETE");
                    console.log(initialReservation);
                    done();
                });
                */
        });
    });
/*
    after(function (done) {
        console.log("AFTER");
        authenticate(function (token) {
            chai.request(server)
                .delete('/v1/sslqi/reservation/' + initialReservation._id)
                .set('Authoriztion', token)
                .send(initialReservation)
                .end(function (err, response) {
                    console.log("AFTER-COMPLETE");
                    done();
                });
        });
    });
    */

    it('Retrieves SSLQI Release Request. GET /v1/sslqi/release', function (done) {
        "use strict";
        chai.request(server)
            .get('/v1/sslqi/release')
            .set('Authorization', token)
            .end(function (err, response) {
                response.should.have.status(200);
                response.should.be.json;
                response.body.should.be.a('array');
                done();
            });
    });

/*
    it('Create new SSLQI Release Request. POST /v1/sslqi/release', function (done) {
        "use strict";
        console.log(testData);
        chai.request(server)
            .post('/v1/sslqi/release')
            .set('Authorization', token)
            .send(testData)
            .end(function (err, response) {
                response.should.have.status(200);
                response.should.be.json;
                testData = response.body;
                testId = response.body._id;
                done();
            });
    });

    it('Edits an existing SSLQI Release Request configuration. PUT /v1/sslqi/release/:id', function (done) {
        "use strict";
        chai.request(server)
            .put('/v1/sslqi/release/' + testId)
            .set('Authorization', token)
            .send(testData)
            .end(function (err, response) {
                response.should.have.status(200);
                response.should.be.json;
                done();
            });
    });

    it('Denies an existing SSLQI Release Request configuration. PUT /v1/sslqi/release/deny/:id', function (done) {
        "use strict";
        chai.request(server)
            .put('/v1/sslqi/release/deny/'+ testId)
            .set('Authorization', token)
            .end(function (err, response) {
                response.should.have.status(200);
                response.should.be.json;
                done();
            });
    });

    it('Approves an existing SSLQI Release Request configuration. PUT /v1/sslqi/release/approve/:id', function (done) {
        "use strict";
        chai.request(server)
            .put('/v1/sslqi/release/approve/'+ testId)
            .set('Authorization', token)
            .end(function (err, response) {
                response.should.have.status(200);
                response.should.be.json;
                done();
            });
    });

    /*
     it('Gets an SSLQI Release Request by search criteria. POST /v1/sslqi/release/search', function(done){
     authenticate(function(token){
     "use strict";
     chai.request(server)
     .post('/v1/sslqi/release/search')
     .set('Authorization', token)
     .send(searchCriteria)
     .end(function(err,response){
     response.should.have.status(200);
     response.should.be.json;
     //response.body.should.be.a('array');
     done();
     });
     })
     });

    it('Retrieves an existing SSLQI Release Request by _id. GET /v1/sslqi/release/:id', function (done) {
        "use strict";
        chai.request(server)
            .get('/v1/sslqi/release/' + testId)
            .set('Authorization', token)
            .end(function (err, response) {
                response.should.have.status(200);
                response.should.be.json;
                response.should.be.a('object');
                done();
            });
    });

    it('DELETE an existing SSLQI Release Request by ID. DELETE /v1/sslqi/release/:id', function (done) {
        "use strict";
        chai.request(server)
            .delete('/v1/sslqi/release/' + testId)
            .set('Authorization', token)
            .end(function (err, response) {
                response.should.have.status(200);
                done();
            });
    });
*/

});
