"use strict";
process.env.NODE_ENV = 'test';
var chai = require('chai');
var chaiHttp = require('chai-http');
var server = require('../index');
var should = chai.should();
const authenticate = require('./test_config');

chai.use(chaiHttp);

let testId;

let testData =   {
    "vendor": "NEW VENDOR",
    "model": "NEW MODEL",
    "size": "2",
    "itemStatus": "Active",
    "classification": "Pharmacy",
    "item": "MEDS",
    "vistaId": "999",
    "comments": "NOT COMMENTS",
    "itemUsage": "10ML/H",
    "specialty": []
};

let testArray =   [
    {
        "vendor": "NEW VENDOR",
        "model": "NEW MODEL",
        "size": "2",
        "itemStatus": "Active",
        "classification": "Supplies",
        "item": "Supply",
        "vistaId": "998",
        "comments": "COMMENTS",
        "itemUsage": "1000ML/H",
        "specialty": []
    },
    {
        "vendor": "NEW VENDOR",
        "model": "NEW MODEL",
        "size": "2",
        "itemStatus": "Active",
        "classification": "Pharmacy",
        "item": "MEDS",
        "vistaId": "999",
        "comments": "NOT COMMENTS",
        "itemUsage": "10ML/H",
        "specialty": []
    }];


let searchCriteria =   {
    "vistaId": "999",
    "classification": "Pharmacy"
};

describe('Manage SSLQI transactions', function() {
    this.timeout(0);


    it('Retrieves SSLQI. GET /v1/sslqi', function(done){
        authenticate(function(token){
            "use strict";
            chai.request(server)
                .get('/v1/sslqi')
                .set('Authorization', token)
                .end(function(err,response){
                    response.should.have.status(200);
                    response.should.be.json;
                    response.body.should.be.a('array');
                    done();
                });
        })
    });

/*
it('Create new SSLQI. POST /v1/sslqi', function(done){
    authenticate(function(token){
        "use strict";
        chai.request(server)
            .post('/v1/sslqi')
            .set('Authorization', token)
            .send(testData)
            .end(function(err,response){
                response.should.have.status(200);
                response.should.be.json;
                testId = response.body._id;
                done();
            });
    })
});

it('Retrieves an existing SSLQI by classification/vistaId. GET /v1/sslqi/:classification/:vistaId', function(done){
    authenticate(function(token){
        "use strict";
        chai.request(server)
            .get('/v1/sslqi/Pharmacy/999')
            .set('Authorization', token)
            .end(function(err,response){
                response.should.have.status(200);
                response.should.be.json;
                response.should.be.a('object');
                done();
            });
    })
});

it('Edits an existing SSLQI configuration. PUT /v1/sslqi/:id', function(done){
    authenticate(function(token){
        "use strict";
        testData.comments = "new comment";
        chai.request(server)
            .put('/v1/sslqi/' + testId)
            .set('Authorization', token)
            .send(testData)
            .end(function(err,response){
                response.should.have.status(200);
                response.should.be.json;
                done();
            });
    })
});

it('Gets an SSLQI by search criteria. POST /v1/sslqi/search', function(done){
    authenticate(function(token){
        "use strict";
        chai.request(server)
            .post('/v1/sslqi/search')
            .set('Authorization', token)
            .send(searchCriteria)
            .end(function(err,response){
                response.should.have.status(200);
                response.should.be.json;
                //response.body.should.be.a('array');
                done();
            });
    })
});

it('Imports a list of new SSLQI. POST /v1/sslqi/import', function(done){
    authenticate(function(token){
        "use strict";
        chai.request(server)
            .post('/v1/sslqi')
            .set('Authorization', token)
            .send(testArray)
            .end(function(err,response){
                response.should.have.status(200);
                response.should.be.json;
                done();
            });
    })
});

it('DELETE an existing SSLQI by ID. DELETE /v1/sslqi/:id', function(done){
    authenticate(function(token){
        "use strict";
        chai.request(server)
            .delete('/v1/sslqi/' + testId)
            .set('Authorization', token)
            .end(function(err,response){
                response.should.have.status(200);
                done();
            });
    })
});

it('DELETE an existing SSLQI by ID. DELETE /v1/sslqi/:classification/:vistaId', function(done){
    authenticate(function(token){
        "use strict";
        chai.request(server)
            .delete('/v1/sslqi/Supplies/998')
            .set('Authorization', token)
            .end(function(err,response){
                response.should.have.status(200);
                console.log("Made it this far.");
                done();
            });
    })
});
*/
});
