"use strict";
process.env.NODE_ENV = 'test';
var chai = require('chai');
var chaiHttp = require('chai-http');
var server = require('../index');
var should = chai.should();
const authenticate = require('./test_config');

chai.use(chaiHttp);

let testData =   {
    "specialty":"1999",
    "defaultRoom":"1",
    "orNonOr":"O"
};


let searchCriteria =   {
    "specialty": "",
    "orNonOr": "O"
};

describe('Manage specialty - specialty room type mapping related transactions', function() {
    this.timeout(0);

    it('GETS all rooms that have default mappings', function(done){
        authenticate(function(token){
            "use strict";
            chai.request(server)
                .get('/v1/specialty/room/config')
                .set('Authorization', token)
                .end(function(err,response){
                    response.should.have.status(200);
                    response.should.be.json;
                    response.body.should.be.a('array');
                    done();
                });
        })
    });

    /*
    it('POST create new specialty room type config mapping', function(done){
        authenticate(function(token){
            "use strict";
            chai.request(server)
                .post('/v1/specialty/room/config')
                .set('Authorization', token)
                .send(testData)
                .end(function(err,response){
                    response.should.have.status(200);
                    response.should.be.json;
                    done();
                });
        })
    });


    it('GET an existing specialty room type config mapping by specialty id', function(done){
        authenticate(function(token){
            "use strict";
            chai.request(server)
                .get('/v1/specialty/room/config/1999')
                .set('Authorization', token)
                .end(function(err,response){
                    response.should.have.status(200);
                    response.should.be.json;
                    response.should.be.a('object');
                    response.body.should.have.property('specialty');
                    done();
                });
        })
    });

    it('PUT edits an existing specialty room type config mapping', function(done){
        authenticate(function(token){
            "use strict";
            testData.defaultRoom = "";
            chai.request(server)
                .put('/v1/specialty/room/config/1999')
                .set('Authorization', token)
                .send(testData)
                .end(function(err,response){
                    response.should.have.status(200);
                    // response.should.be.json;
                    done();
                });
        })
    });

    it('GET an existing room by config criteria', function(done){
        authenticate(function(token){
            "use strict";
            chai.request(server)
                .post('/v1/specialty/room/config/search')
                .set('Authorization', token)
                .send(searchCriteria)
                .end(function(err,response){
                    response.should.have.status(200);
                    response.should.be.json;
                    response.body.should.be.a('array');
                    done();
                });
        })
    });

    it('DELETE an existing specialty room type config mapping by specialty id', function(done){
        authenticate(function(token){
            "use strict";
            chai.request(server)
                .delete('/v1/specialty/room/config/1999')
                .set('Authorization', token)
                .end(function(err,response){
                    response.should.have.status(200);
                    done();
                });
        })
    });
    */
});
