process.env.NODE_ENV = 'test';
var chai = require('chai');
var chaiHttp = require('chai-http');
var server = require('../index');
var should = chai.should();
const authenticate = require('./test_config');

chai.use(chaiHttp);
let token;

describe('v1 field - /v1/field/...', function () {
    this.timeout(0);

    before(function (done) {
        "use strict";
        console.log("BEFORE");
        authenticate(function (t) {
            token = t;
            done();
        });

    });

    it('should get a list of values for the case schedule type field', function (done) {

        "use strict";
        chai.request(server)
            .get('/v1/field/caseScheduleType')
            .set('Authorization', token)
            .end(function (err, response) {
                response.should.have.status(200);
                response.should.be.json;
                response.body.should.be.a('array');
                done();
            });
    });

    it('should get a list of values for preoperative infections field field', function (done) {
        "use strict";
        chai.request(server)
            .get('/v1/field/preOpInfection')
            .set('Authorization', token)
            .end(function (err, response) {
                response.should.have.status(200);
                response.should.be.json;
                response.body.should.be.a('array');
                done();
            });
    });

    it('should get a list of values for anesthesia techniques field', function (done) {
        "use strict";
        chai.request(server)
            .get('/v1/field/anesthesiaTechnique')
            .set('Authorization', token)
            .end(function (err, response) {
                response.should.have.status(200);
                response.should.be.json;
                response.body.should.be.a('array');
                done();
            });
    });


    it('should get a list of values for admission status fields', function (done) {
        "use strict";
        chai.request(server)
            .get('/v1/field/admissionStatus')
            .set('Authorization', token)
            .end(function (err, response) {
                response.should.have.status(200);
                response.should.be.json;
                response.body.should.be.a('array');
                done();
            });
    });

    it('should get a list of values for intraoperative x-ray field', function (done) {
        "use strict";
        chai.request(server)
            .get('/v1/field/intraoperativeXrays')
            .set('Authorization', token)
            .end(function (err, response) {
                response.should.have.status(200);
                response.should.be.json;
                response.body.should.be.a('array');
                done();
            });
    });

    it('should get a list of values for blood type cross match field', function (done) {
        "use strict";
        chai.request(server)
            .get('/v1/field/bloodTypeXmatch')
            .set('Authorization', token)
            .end(function (err, response) {
                response.should.have.status(200);
                response.should.be.json;
                response.body.should.be.a('array');
                done();
            });
    });

    it('should get a list of values for cancel time frame field', function (done) {
        "use strict";
        chai.request(server)
            .get('/v1/field/cancelTimeframe')
            .set('Authorization', token)
            .end(function (err, response) {
                response.should.have.status(200);
                response.should.be.json;
                response.body.should.be.a('array');
                done();
            });
    });

    it('should get a list of values for blood product field', function (done) {
        "use strict";
        chai.request(server)
            .get('/v1/field/bloodProductInfo')
            .set('Authorization', token)
            .end(function (err, response) {
                response.should.have.status(200);
                response.should.be.json;
                response.body.should.be.a('array');
                done();
            });
    });

    it('should get a list of values for procedure laterality field', function (done) {
        "use strict";
        chai.request(server)
            .get('/v1/field/procedureLaterality')
            .set('Authorization', token)
            .end(function (err, response) {
                response.should.have.status(200);
                response.should.be.json;
                response.body.should.be.a('array');
                done();
            });
    });

    it('should get a list of values for case type field', function (done) {
        "use strict";
        chai.request(server)
            .get('/v1/field/case_type')
            .set('Authorization', token)
            .end(function (err, response) {
                response.should.have.status(200);
                response.should.be.json;
                response.body.should.be.a('array');
                done();
            });
    });

    it('should get a list of values for case status field', function (done) {
        "use strict";
        chai.request(server)
            .get('/v1/field/case_status')
            .set('Authorization', token)
            .end(function (err, response) {
                response.should.have.status(200);
                response.should.be.json;
                response.body.should.be.a('array');
                done();
            });
    });

    it('should get a list of values for SSLQI classification field', function (done) {
        "use strict";
        chai.request(server)
            .get('/v1/field/sslqi/classification')
            .set('Authorization', token)
            .end(function (err, response) {
                response.should.have.status(200);
                response.should.be.json;
                response.body.should.be.a('array');
                done();
            });
    });


    it('should get a list of values for packing', function(done){
        "use strict";
        chai.request(server)
            .get('/v1/field/packing')
            .set('Authorization', token)
            .end(function(err,response){
                response.should.have.status(200);
                response.should.be.json;
                response.body.should.be.a('array');
                done();
            });
    });

    it('should get a list of values for patient edu assessment', function(done){
        "use strict";
        chai.request(server)
            .get('/v1/field/patient_edu_assessment')
            .set('Authorization', token)
            .end(function(err,response){
                response.should.have.status(200);
                response.should.be.json;
                response.body.should.be.a('array');
                done();
            });
    });

    it('should get a list of values for wound classification', function(done){
        "use strict";
        chai.request(server)
            .get('/v1/field/wound_classification')
            .set('Authorization', token)
            .end(function(err,response){
                response.should.have.status(200);
                response.should.be.json;
                response.body.should.be.a('array');
                done();
            });
    });

    it('should get a list of values for hair removal method', function(done){
        "use strict";
        chai.request(server)
            .get('/v1/field/hair_removal_method')
            .set('Authorization', token)
            .end(function(err,response){
                response.should.have.status(200);
                response.should.be.json;
                response.body.should.be.a('array');
                done();
            });
    });

    it('should get a list of values for general', function(done){
        "use strict";
        chai.request(server)
            .get('/v1/field/general')
            .set('Authorization', token)
            .end(function(err,response){
                response.should.have.status(200);
                response.should.be.json;
                response.body.should.be.a('array');
                done();
            });
    });

    it('should get a list of values for diabetes melitus', function(done){
        "use strict";
        chai.request(server)
            .get('/v1/field/diabetes_mellitus')
            .set('Authorization', token)
            .end(function(err,response){
                response.should.have.status(200);
                response.should.be.json;
                response.body.should.be.a('array');
                done();
            });
    });

    it('should get a list of values for tobacco use', function(done){
        "use strict";
        chai.request(server)
            .get('/v1/field/tobacco_use')
            .set('Authorization', token)
            .end(function(err,response){
                response.should.have.status(200);
                response.should.be.json;
                response.body.should.be.a('array');
                done();
            });
    });

    it('should get a list of values for tobacco timeframe', function(done){
        "use strict";
        chai.request(server)
            .get('/v1/field/tobacco_timeframe')
            .set('Authorization', token)
            .end(function(err,response){
                response.should.have.status(200);
                response.should.be.json;
                response.body.should.be.a('array');
                done();
            });
    });

    it('should get a list of values for two drinks per day', function(done){
        "use strict";
        chai.request(server)
            .get('/v1/field/two_drinks_day')
            .set('Authorization', token)
            .end(function(err,response){
                response.should.have.status(200);
                response.should.be.json;
                response.body.should.be.a('array');
                done();
            });
    });

    it('should get a list of values for positive dr scrn', function(done){
        "use strict";
        chai.request(server)
            .get('/v1/field/positive_drug_screening')
            .set('Authorization', token)
            .end(function(err,response){
                response.should.have.status(200);
                response.should.be.json;
                response.body.should.be.a('array');
                done();
            });
    });

    it('should get a list of values for dyspnea', function(done){
        "use strict";
        chai.request(server)
            .get('/v1/field/dyspnea')
            .set('Authorization', token)
            .end(function(err,response){
                response.should.have.status(200);
                response.should.be.json;
                response.body.should.be.a('array');
                done();
            });
    });

    it('should get a list of values for preop sleep apnea', function(done){
        "use strict";
        chai.request(server)
            .get('/v1/field/preop_sleep_apnea')
            .set('Authorization', token)
            .end(function(err,response){
                response.should.have.status(200);
                response.should.be.json;
                response.body.should.be.a('array');
                done();
            });
    });

    it('should get a list of values for dnr status', function(done){
        "use strict";
        chai.request(server)
            .get('/v1/field/dnr_status')
            .set('Authorization', token)
            .end(function(err,response){
                response.should.have.status(200);
                response.should.be.json;
                response.body.should.be.a('array');
                done();
            });
    });

    it('should get a list of values for functional health status', function(done){
        "use strict";
        chai.request(server)
            .get('/v1/field/functional_health_status')
            .set('Authorization', token)
            .end(function(err,response){
                response.should.have.status(200);
                response.should.be.json;
                response.body.should.be.a('array');
                done();
            });
    });

    it('should get a list of values for residence', function(done){
        "use strict";
        chai.request(server)
            .get('/v1/field/residence')
            .set('Authorization', token)
            .end(function(err,response){
                response.should.have.status(200);
                response.should.be.json;
                response.body.should.be.a('array');
                done();
            });
    });

    it('should get a list of values for ambulation device', function(done){
        "use strict";
        chai.request(server)
            .get('/v1/field/ambulation_device')
            .set('Authorization', token)
            .end(function(err,response){
                response.should.have.status(200);
                response.should.be.json;
                response.body.should.be.a('array');
                done();
            });
    });

    it('should get a list of values for homeless', function(done){
        "use strict";
        chai.request(server)
            .get('/v1/field/homeless')
            .set('Authorization', token)
            .end(function(err,response){
                response.should.have.status(200);
                response.should.be.json;
                response.body.should.be.a('array');
                done();
            });
    });

    it('should get a list of values for pulmonary', function(done){
        "use strict";
        chai.request(server)
            .get('/v1/field/pulmonary')
            .set('Authorization', token)
            .end(function(err,response){
                response.should.have.status(200);
                response.should.be.json;
                response.body.should.be.a('array');
                done();
            });
    });

    it('should get a list of values for ventilator dependent', function(done){
        "use strict";
        chai.request(server)
            .get('/v1/field/ventilator_dependent')
            .set('Authorization', token)
            .end(function(err,response){
                response.should.have.status(200);
                response.should.be.json;
                response.body.should.be.a('array');
                done();
            });
    });

    it('should get a list of values for copd history', function(done){
        "use strict";
        chai.request(server)
            .get('/v1/field/copd_history')
            .set('Authorization', token)
            .end(function(err,response){
                response.should.have.status(200);
                response.should.be.json;
                response.body.should.be.a('array');
                done();
            });
    });

    it('should get a list of values for current pneumonia', function(done){
        "use strict";
        chai.request(server)
            .get('/v1/field/current_pneumonia')
            .set('Authorization', token)
            .end(function(err,response){
                response.should.have.status(200);
                response.should.be.json;
                response.body.should.be.a('array');
                done();
            });
    });

    it('should get a list of values for hepatobiliary', function(done){
        "use strict";
        chai.request(server)
            .get('/v1/field/hepatobiliary')
            .set('Authorization', token)
            .end(function(err,response){
                response.should.have.status(200);
                response.should.be.json;
                response.body.should.be.a('array');
                done();
            });
    });

    it('should get a list of values for ascites', function(done){
        "use strict";
        chai.request(server)
            .get('/v1/field/ascites')
            .set('Authorization', token)
            .end(function(err,response){
                response.should.have.status(200);
                response.should.be.json;
                response.body.should.be.a('array');
                done();
            });
    });

    it('should get a list of values for gastrointestinal', function(done){
        "use strict";
        chai.request(server)
            .get('/v1/field/gastrointestinal')
            .set('Authorization', token)
            .end(function(err,response){
                response.should.have.status(200);
                response.should.be.json;
                response.body.should.be.a('array');
                done();
            });
    });

    it('should get a list of values for esophageal varices', function(done){
        "use strict";
        chai.request(server)
            .get('/v1/field/esophageal_varices')
            .set('Authorization', token)
            .end(function(err,response){
                response.should.have.status(200);
                response.should.be.json;
                response.body.should.be.a('array');
                done();
            });
    });

    it('should get a list of values for congestive heart failure preop', function(done){
        "use strict";
        chai.request(server)
            .get('/v1/field/congestive_heart_failure_preop')
            .set('Authorization', token)
            .end(function(err,response){
                response.should.have.status(200);
                response.should.be.json;
                response.body.should.be.a('array');
                done();
            });
    });

    it('should get a list of values for cardiac', function(done){
        "use strict";
        chai.request(server)
            .get('/v1/field/cardiac')
            .set('Authorization', token)
            .end(function(err,response){
                response.should.have.status(200);
                response.should.be.json;
                response.body.should.be.a('array');
                done();
            });
    });

    it('should get a list of values for prior mi', function(done){
        "use strict";
        chai.request(server)
            .get('/v1/field/prior_mi')
            .set('Authorization', token)
            .end(function(err,response){
                response.should.have.status(200);
                response.should.be.json;
                response.body.should.be.a('array');
                done();
            });
    });

    it('should get a list of values for pci', function(done){
        "use strict";
        chai.request(server)
            .get('/v1/field/pci')
            .set('Authorization', token)
            .end(function(err,response){
                response.should.have.status(200);
                response.should.be.json;
                response.body.should.be.a('array');
                done();
            });
    });

    it('should get a list of values for angina timeframe', function(done){
        "use strict";
        chai.request(server)
            .get('/v1/field/angina_timeframe')
            .set('Authorization', token)
            .end(function(err,response){
                response.should.have.status(200);
                response.should.be.json;
                response.body.should.be.a('array');
                done();
            });
    });

    it('should get a list of values for angina severity', function(done){
        "use strict";
        chai.request(server)
            .get('/v1/field/angina_severity')
            .set('Authorization', token)
            .end(function(err,response){
                response.should.have.status(200);
                response.should.be.json;
                response.body.should.be.a('array');
                done();
            });
    });

    it('should get a list of values for hypertension', function(done){
        "use strict";
        chai.request(server)
            .get('/v1/field/hypertension')
            .set('Authorization', token)
            .end(function(err,response){
                response.should.have.status(200);
                response.should.be.json;
                response.body.should.be.a('array');
                done();
            });
    });

    it('should get a list of values for prior surg same op field', function(done){
        "use strict";
        chai.request(server)
            .get('/v1/field/prior_surg_same_op_field')
            .set('Authorization', token)
            .end(function(err,response){
                response.should.have.status(200);
                response.should.be.json;
                response.body.should.be.a('array');
                done();
            });
    });

    it('should get a list of values for hx rad rx planned surg field', function(done){
        "use strict";
        chai.request(server)
            .get('/v1/field/hx_rad_rx_planned_surg_field')
            .set('Authorization', token)
            .end(function(err,response){
                response.should.have.status(200);
                response.should.be.json;
                response.body.should.be.a('array');
                done();
            });
    });

    it('should get a list of values for donor serology', function(done){
        "use strict";
        chai.request(server)
            .get('/v1/field/donor_serology')
            .set('Authorization', token)
            .end(function(err,response){
                response.should.have.status(200);
                response.should.be.json;
                response.body.should.be.a('array');
                done();
            });
    });

    it('should get a list of values for vascular', function(done){
        "use strict";
        chai.request(server)
            .get('/v1/field/vascular')
            .set('Authorization', token)
            .end(function(err,response){
                response.should.have.status(200);
                response.should.be.json;
                response.body.should.be.a('array');
                done();
            });
    });

    it('should get a list of values for peripheral arterial disease', function(done){
        "use strict";
        chai.request(server)
            .get('/v1/field/peripheral_arterial_disease')
            .set('Authorization', token)
            .end(function(err,response){
                response.should.have.status(200);
                response.should.be.json;
                response.body.should.be.a('array');
                done();
            });
    });

    it('should get a list of values for rest pain gaingrene', function(done){
        "use strict";
        chai.request(server)
            .get('/v1/field/rest_pain_gaingrene')
            .set('Authorization', token)
            .end(function(err,response){
                response.should.have.status(200);
                response.should.be.json;
                response.body.should.be.a('array');
                done();
            });
    });

    it('should get a list of values for renal', function(done){
        "use strict";
        chai.request(server)
            .get('/v1/field/renal')
            .set('Authorization', token)
            .end(function(err,response){
                response.should.have.status(200);
                response.should.be.json;
                response.body.should.be.a('array');
                done();
            });
    });

    it('should get a list of values for renal failure', function(done){
        "use strict";
        chai.request(server)
            .get('/v1/field/renal_failure')
            .set('Authorization', token)
            .end(function(err,response){
                response.should.have.status(200);
                response.should.be.json;
                response.body.should.be.a('array');
                done();
            });
    });

    it('should get a list of values for on dialysis', function(done){
        "use strict";
        chai.request(server)
            .get('/v1/field/on_dialysis')
            .set('Authorization', token)
            .end(function(err,response){
                response.should.have.status(200);
                response.should.be.json;
                response.body.should.be.a('array');
                done();
            });
    });

    it('should get a list of values for central nerv sys illness', function(done){
        "use strict";
        chai.request(server)
            .get('/v1/field/central_nerv_sys_illness')
            .set('Authorization', token)
            .end(function(err,response){
                response.should.have.status(200);
                response.should.be.json;
                response.body.should.be.a('array');
                done();
            });
    });

    it('should get a list of values for impaired sensorium', function(done){
        "use strict";
        chai.request(server)
            .get('/v1/field/impaired_sensorium')
            .set('Authorization', token)
            .end(function(err,response){
                response.should.have.status(200);
                response.should.be.json;
                response.body.should.be.a('array');
                done();
            });
    });

    it('should get a list of values for coma', function(done){
        "use strict";
        chai.request(server)
            .get('/v1/field/coma')
            .set('Authorization', token)
            .end(function(err,response){
                response.should.have.status(200);
                response.should.be.json;
                response.body.should.be.a('array');
                done();
            });
    });

    it('should get a list of values for hemiplegia hemipareses', function(done){
        "use strict";
        chai.request(server)
            .get('/v1/field/hemiplegia_hemiparesis')
            .set('Authorization', token)
            .end(function(err,response){
                response.should.have.status(200);
                response.should.be.json;
                response.body.should.be.a('array');
                done();
            });
    });

    it('should get a list of values for history of cvd', function(done){
        "use strict";
        chai.request(server)
            .get('/v1/field/history_of_cvd')
            .set('Authorization', token)
            .end(function(err,response){
                response.should.have.status(200);
                response.should.be.json;
                response.body.should.be.a('array');
                done();
            });
    });

    it('should get a list of values for cns tumor', function(done){
        "use strict";
        chai.request(server)
            .get('/v1/field/tumor_involving_cns')
            .set('Authorization', token)
            .end(function(err,response){
                response.should.have.status(200);
                response.should.be.json;
                response.body.should.be.a('array');
                done();
            });
    });

    it('should get a list of values for impaired cognitive function', function(done){
        "use strict";
        chai.request(server)
            .get('/v1/field/impaired_cognitive_function')
            .set('Authorization', token)
            .end(function(err,response){
                response.should.have.status(200);
                response.should.be.json;
                response.body.should.be.a('array');
                done();
            });
    });

    it('should get a list of values for nutritional immune other', function(done){
        "use strict";
        chai.request(server)
            .get('/v1/field/nutritional_immune_other')
            .set('Authorization', token)
            .end(function(err,response){
                response.should.have.status(200);
                response.should.be.json;
                response.body.should.be.a('array');
                done();
            });
    });

    it('should get a list of values for disseminated cancer', function(done){
        "use strict";
        chai.request(server)
            .get('/v1/field/disseminated_cancer')
            .set('Authorization', token)
            .end(function(err,response){
                response.should.have.status(200);
                response.should.be.json;
                response.body.should.be.a('array');
                done();
            });
    });

    it('should get a list of values for open wound', function(done){
        "use strict";
        chai.request(server)
            .get('/v1/field/open_wound')
            .set('Authorization', token)
            .end(function(err,response){
                response.should.have.status(200);
                response.should.be.json;
                response.body.should.be.a('array');
                done();
            });
    });

    it('should get a list of values for chronic steroid use', function(done){
        "use strict";
        chai.request(server)
            .get('/v1/field/chronic_steroid_use')
            .set('Authorization', token)
            .end(function(err,response){
                response.should.have.status(200);
                response.should.be.json;
                response.body.should.be.a('array');
                done();
            });
    });

    it('should get a list of values for ten perc weight loss', function(done){
        "use strict";
        chai.request(server)
            .get('/v1/field/ten_perc_weight_loss')
            .set('Authorization', token)
            .end(function(err,response){
                response.should.have.status(200);
                response.should.be.json;
                response.body.should.be.a('array');
                done();
            });
    });

    it('should get a list of values for bleeding disorders', function(done){
        "use strict";
        chai.request(server)
            .get('/v1/field/bleeding_disorders')
            .set('Authorization', token)
            .end(function(err,response){
                response.should.have.status(200);
                response.should.be.json;
                response.body.should.be.a('array');
                done();
            });
    });

    it('should get a list of values for med bleeding risk', function(done){
        "use strict";
        chai.request(server)
            .get('/v1/field/medication_bleeding_risk')
            .set('Authorization', token)
            .end(function(err,response){
                response.should.have.status(200);
                response.should.be.json;
                response.body.should.be.a('array');
                done();
            });
    });

    it('should get a list of values for transfusion gt four rbcs', function(done){
        "use strict";
        chai.request(server)
            .get('/v1/field/transfusion_gt_four_rbcs')
            .set('Authorization', token)
            .end(function(err,response){
                response.should.have.status(200);
                response.should.be.json;
                response.body.should.be.a('array');
                done();
            });
    });

    it('should get a list of values for mailg chemo', function(done){
        "use strict";
        chai.request(server)
            .get('/v1/field/malig_chemo')
            .set('Authorization', token)
            .end(function(err,response){
                response.should.have.status(200);
                response.should.be.json;
                response.body.should.be.a('array');
                done();
            });
    });

    it('should get a list of values for radio therapy last ninety', function(done){
        "use strict";
        chai.request(server)
            .get('/v1/field/radio_therapy_last_ninety')
            .set('Authorization', token)
            .end(function(err,response){
                response.should.have.status(200);
                response.should.be.json;
                response.body.should.be.a('array');
                done();
            });
    });

    it('should get a list of values for preop sepsis', function(done){
        "use strict";
        chai.request(server)
            .get('/v1/field/preop_sepsis')
            .set('Authorization', token)
            .end(function(err,response){
                response.should.have.status(200);
                response.should.be.json;
                response.body.should.be.a('array');
                done();
            });
    });

    it('should get a list of values for pregnancy', function(done){
        "use strict";
        chai.request(server)
            .get('/v1/field/pregnancy')
            .set('Authorization', token)
            .end(function(err,response){
                response.should.have.status(200);
                response.should.be.json;
                response.body.should.be.a('array');
                done();
            });
    });

    it('should get a list of values for assessment types', function(done){
        "use strict";
        chai.request(server)
            .get('/v1/field/assessment_type')
            .set('Authorization', token)
            .end(function(err,response){
                response.should.have.status(200);
                response.should.be.json;
                response.body.should.be.a('array');
                done();
            });
    });

});
