"use strict";
process.env.NODE_ENV = 'test';
var chai = require('chai');
var chaiHttp = require('chai-http');
var server = require('../index');
var should = chai.should();
const authenticate = require('./test_config');

chai.use(chaiHttp);

let testData =   {
    "roomTypeId":"99",
    "cptCode":["15273", "1"],
    "specialty":["1", "5", "10", "18", "17"],
    "orNonOr":"OR"
};


let searchCriteria =   {
    "specialty": [
        "2"
    ],
    "orNor": "OR"
};

describe('Manage room related transactions', function() {
    this.timeout(0);
    it('GET room details by room ID', function(done){
        authenticate(function(token){
            "use strict";
            chai.request(server)
                .get('/v1/room/or/17')
                .set('Authorization', token)
                .end(function(err,response){
                    response.should.have.status(200);
                    response.should.be.json;
                    done();
                });
        })
    });

    it('GET room details for room that is associated with specified case', function(done){
        authenticate(function(token){
            "use strict";
            chai.request(server)
                .get('/v1/cases/room/44')
                .set('Authorization', token)
                .end(function(err,response){
                    response.should.have.status(200);
                    response.should.be.json;
                    done();
                });
        })
    });

});
