process.env.NODE_ENV = 'test';
var chai = require('chai');
var chaiHttp = require('chai-http');
var server = require('../index');
var should = chai.should();
const authenticate = require('./test_config');

chai.use(chaiHttp);

describe('Tests the management of requrested cases', function() {
    this.timeout(0);

    it('should get a list of requested cases for specified year and month', function(done){
        authenticate(function(token){
            "use strict";
            chai.request(server)
                .get('/v1/cases/requested/date/2017/01')
                .set('Authorization', token)
                .end(function(err,response){
                    response.should.have.status(200);
                    response.should.be.json;
                    response.body.should.be.a('array');
                    done();
                });
        })
    });

    it('should get a list of requested cases for specified year, month, and day', function(done){
        authenticate(function(token){
            "use strict";
            chai.request(server)
                .get('/v1/cases/requested/date/2017/01/03')
                .set('Authorization', token)
                .end(function(err,response){
                    response.should.have.status(200);
                    response.should.be.json;
                    response.body.should.be.a('array');
                    done();
                });
        })
    });

});
