'use strict';
process.env.NODE_ENV = 'test';
var chai = require('chai');
var chaiHttp = require('chai-http');
var server = require('../index');
var should = chai.should();
const authenticate = require('./test_config');

chai.use(chaiHttp);

describe('v1 patient', function() {
  this.timeout(0);
  it('should get a valid patient for f0500', function(done){
  	authenticate(function(token){
  		"use strict";
        chai.request(server)
            .get('/v1/patient/five/F0501')
			.set("Authorization", token)
            .end(function(err,res){
                res.should.have.status(200);
                res.should.be.json;
                done();
            })
	})
  });

    it('should get a valid patient for dfn=8', function(done){
    	authenticate((function(token){
    		"use strict";
            chai.request(server)
                .get('/v1/patient/8')
				.set("Authorization", token)
                .end(function(err,res){
                    res.should.have.status(200);
                    res.should.be.json;
                    done();
                })
		}))
    });

    it('should get a valid patient for ssn=123450500', function(done){
        authenticate((function(token){
            "use strict";
            chai.request(server)
                .get('/v1/patient/ssn/123450500')
                .set("Authorization", token)
                .end(function(err,res){
                    res.should.have.status(200);
                    res.should.be.json;
                    done();
                })
        }))
    });

    it('should get a list of cases for patient with dfn=8 /v1/patient/8/cases', function(done){
        authenticate((function(token){
            "use strict";
            chai.request(server)
                .get('/v1/patient/8/cases')
                .set("Authorization", token)
                .end(function(err,res){
                    res.should.have.status(200);
                    res.should.be.json;
                    res.body.should.be.a('array');
                    done();
                })
        }))
    });

    it('should get a list of placeholder cases for patient with dfn=8', function(done){
        authenticate((function(token){
            "use strict";
            chai.request(server)
                .get('/v1/patient/8/cases/placeholder')
                .set("Authorization", token)
                .end(function(err,res){
                    res.should.have.status(200);
                    res.should.be.json;
                    res.body.should.be.a('array');
                    done();
                })
        }))
    });

    it('should get a list of OR cases for patient with dfn=8', function(done){
        authenticate((function(token){
            "use strict";
            chai.request(server)
                .get('/v1/patient/8/cases/or')
                .set("Authorization", token)
                .end(function(err,res){
                    res.should.have.status(200);
                    res.should.be.json;
                    res.body.should.be.a('array');
                    done();
                })
        }))
    });

    it('should get a list of Non-OR cases for patient with dfn=8', function(done){
        authenticate((function(token){
            "use strict";
            chai.request(server)
                .get('/v1/patient/8/cases/nor')
                .set("Authorization", token)
                .end(function(err,res){
                    res.should.have.status(200);
                    res.should.be.json;
                    res.body.should.be.a('array');
                    done();
                })
        }))
    });
});
