process.env.NODE_ENV = 'test';
var chai = require('chai');
var chaiHttp = require('chai-http');
var server = require('../index');
var should = chai.should();
const authenticate = require('./test_config');

chai.use(chaiHttp);

describe('v1 list', function() {
    this.timeout(0);
    it('should get a list of people', function(done){
        authenticate(function(token){
            "use strict";
            chai.request(server)
                .get('/v1/list/people')
                .set('Authorization', token)
                .end(function(err,response){
                    response.should.have.status(200);
                    response.should.be.json;
                    response.body.should.be.a('array');
                    done();
                });
        })
    });

    it('should get a list of specialties', function(done){
        authenticate(function(token){
            "use strict";
            chai.request(server)
                .get('/v1/list/specialty')
                .set('Authorization', token)
                .end(function(err,response){
                    response.should.have.status(200);
                    response.should.be.json;
                    response.body.should.be.a('array');
                    done();
                });
        })
    });

    it('should get a list of Operating Room types', function(done){
        authenticate(function(token){
            "use strict";
            chai.request(server)
                .get('/v1/list/or/types')
                .set('Authorization', token)
                .end(function(err,response){
                    response.should.have.status(200);
                    response.should.be.json;
                    response.body.should.be.a('array');
                    done();
                });
        })
    });


    it('should get a list of Operating Rooms', function(done){
        authenticate(function(token){
            "use strict";
            chai.request(server)
                .get('/v1/list/or')
                .set('Authorization', token)
                .end(function(err,response){
                    response.should.have.status(200);
                    response.should.be.json;
                    response.body.should.be.a('array');
                    done();
                });
        })
    });

    it('should get a list of case closure reasons', function(done){
        authenticate(function(token){
            "use strict";
            chai.request(server)
                .get('/v1/list/closureReasons')
                .set('Authorization', token)
                .end(function(err,response){
                    response.should.have.status(200);
                    response.should.be.json;
                    response.body.should.be.a('array');
                    done();
                });
        })
    });

    it('should get a list of case cancel reasons', function(done){
        authenticate(function(token){
            "use strict";
            chai.request(server)
                .get('/v1/list/cancelReasons')
                .set('Authorization', token)
                .end(function(err,response){
                    response.should.have.status(200);
                    response.should.be.json;
                    response.body.should.be.a('array');
                    done();
                });
        })
    });
    /////////////
    it('should get a list of skin integrity options', function(done){
        authenticate(function(token){
            "use strict";
            chai.request(server)
                .get('/v1/list/skin_integrity')
                .set('Authorization', token)
                .end(function(err,response){
                    response.should.have.status(200);
                    response.should.be.json;
                    response.body.should.be.a('array');
                    done();
                });
        })
    });

    it('should get a list of surgery transport devices', function(done){
        authenticate(function(token){
            "use strict";
            chai.request(server)
                .get('/v1/list/surg_trans_device')
                .set('Authorization', token)
                .end(function(err,response){
                    response.should.have.status(200);
                    response.should.be.json;
                    response.body.should.be.a('array');
                    done();
                });
        })
    });

    it('should get a list of resstraint position aids', function(done){
        authenticate(function(token){
            "use strict";
            chai.request(server)
                .get('/v1/list/restraint_pos_aids')
                .set('Authorization', token)
                .end(function(err,response){
                    response.should.have.status(200);
                    response.should.be.json;
                    response.body.should.be.a('array');
                    done();
                });
        })
    });


    it('should get a list of skin prep agents', function(done){
        authenticate(function(token){
            "use strict";
            chai.request(server)
                .get('/v1/list/skin_prep_agents')
                .set('Authorization', token)
                .end(function(err,response){
                    response.should.have.status(200);
                    response.should.be.json;
                    response.body.should.be.a('array');
                    done();
                });
        })
    });

    it('should get a list of patient mood options', function(done){
        authenticate(function(token){
            "use strict";
            chai.request(server)
                .get('/v1/list/patient_moods')
                .set('Authorization', token)
                .end(function(err,response){
                    response.should.have.status(200);
                    response.should.be.json;
                    response.body.should.be.a('array');
                    done();
                });
        })
    });

    it('should get a list of patient conscious', function(done){
        authenticate(function(token){
            "use strict";
            chai.request(server)
                .get('/v1/list/patient_conscious')
                .set('Authorization', token)
                .end(function(err,response){
                    response.should.have.status(200);
                    response.should.be.json;
                    response.body.should.be.a('array');
                    done();
                });
        })
    });


    it('should get a list of dispositions', function(done){
        authenticate(function(token){
            "use strict";
            chai.request(server)
                .get('/v1/list/disposition')
                .set('Authorization', token)
                .end(function(err,response){
                    response.should.have.status(200);
                    response.should.be.json;
                    response.body.should.be.a('array');
                    done();
                });
        })
    });

    it('should get a list of electro ground position', function(done){
        authenticate(function(token){
            "use strict";
            chai.request(server)
                .get('/v1/list/electro_ground_position')
                .set('Authorization', token)
                .end(function(err,response){
                    response.should.have.status(200);
                    response.should.be.json;
                    response.body.should.be.a('array');
                    done();
                });
        })
    });

});
